/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.traffic;

import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.FrameIoHandler;
import org.noear.socketd.transport.core.TrafficLimiter;
import org.noear.socketd.utils.IoCompletionHandler;
import org.noear.socketd.utils.RunUtils;

public class TrafficLimiterDefault
implements TrafficLimiter {
    private int sendRate;
    private int receRate;
    private final long interval = 1000L;
    private volatile int sendCount;
    private volatile int receCount;
    private volatile long sendLatestLimitTime = Long.MIN_VALUE;
    private volatile long receLatestLimitTime = Long.MIN_VALUE;
    private long receLatestTime = Long.MIN_VALUE;
    private long sendLatestTime = Long.MIN_VALUE;

    public int getSendRate() {
        return this.sendRate;
    }

    public void setSendRate(int sendRate) {
        this.sendRate = sendRate;
    }

    public int getReceRate() {
        return this.receRate;
    }

    public void setReceRate(int receRate) {
        this.receRate = receRate;
    }

    public TrafficLimiterDefault(int sendAndReceRate) {
        this(sendAndReceRate, sendAndReceRate);
    }

    public TrafficLimiterDefault(int sendRate, int receRate) {
        this.sendRate = sendRate;
        this.receRate = receRate;
    }

    @Override
    public <S> void sendFrame(FrameIoHandler frameIoHandler, ChannelInternal channel, Frame frame, ChannelAssistant<S> channelAssistant, S target, IoCompletionHandler completionHandler) {
        if (this.sendRate < 1) {
            frameIoHandler.sendFrameHandle(channel, frame, channelAssistant, target, completionHandler);
            return;
        }
        if (this.sendLatestTime >= this.sendLatestLimitTime) {
            this.sendCount = 0;
            this.sendLatestLimitTime = RunUtils.milliSecondFromNano() + 1000L;
        }
        if (this.sendCount < this.sendRate) {
            ++this.sendCount;
            frameIoHandler.sendFrameHandle(channel, frame, channelAssistant, target, completionHandler);
        } else {
            this.sendLatestTime = RunUtils.milliSecondFromNano();
            if (this.sendLatestTime < this.sendLatestLimitTime) {
                try {
                    Thread.sleep(this.sendLatestLimitTime - this.sendLatestTime);
                }
                catch (Throwable e) {
                    return;
                }
            }
            this.sendFrame(frameIoHandler, channel, frame, channelAssistant, target, completionHandler);
        }
    }

    @Override
    public void reveFrame(FrameIoHandler frameIoHandler, ChannelInternal channel, Frame frame) {
        if (this.receRate < 1) {
            frameIoHandler.reveFrameHandle(channel, frame);
            return;
        }
        if (this.receLatestTime >= this.receLatestLimitTime) {
            this.receCount = 0;
            this.receLatestLimitTime = RunUtils.milliSecondFromNano() + 1000L;
        }
        if (this.receCount < this.receRate) {
            ++this.receCount;
            frameIoHandler.reveFrameHandle(channel, frame);
        } else {
            this.receLatestTime = RunUtils.milliSecondFromNano();
            if (this.receLatestTime < this.receLatestLimitTime) {
                try {
                    Thread.sleep(this.receLatestLimitTime - this.receLatestTime);
                }
                catch (Throwable e) {
                    return;
                }
            }
            this.reveFrame(frameIoHandler, channel, frame);
        }
    }
}

