/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.java_websocket.WebSocket;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.socketd.utils.IoCompletionHandler;

public class WsNioChannelAssistant
implements ChannelAssistant<WebSocket> {
    private final Config config;

    public WsNioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(WebSocket source, Frame frame, ChannelInternal channel, IoCompletionHandler completionHandler) {
        try {
            if (frame.flag() == 20) {
                source.sendPing();
            }
            ByteBufferCodecWriter writer = (ByteBufferCodecWriter)this.config.getCodec().write(frame, len -> new ByteBufferCodecWriter(ByteBuffer.allocate(len)));
            source.send(writer.getBuffer());
            completionHandler.completed(true, null);
        }
        catch (Throwable e) {
            completionHandler.completed(false, e);
        }
    }

    public boolean isValid(WebSocket target) {
        return target.isOpen();
    }

    public void close(WebSocket target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(WebSocket target) {
        return target.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress(WebSocket target) {
        return target.getLocalSocketAddress();
    }

    public Frame read(ByteBuffer buffer) throws IOException {
        return this.config.getCodec().read((CodecReader)new ByteBufferCodecReader(buffer));
    }
}

