/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_websocket;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.java_websocket.WsNioClient;
import org.noear.socketd.transport.java_websocket.impl.WebSocketClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsNioClientConnector
extends ClientConnectorBase<WsNioClient> {
    private static final Logger log = LoggerFactory.getLogger(WsNioClientConnector.class);
    private WebSocketClientImpl real;

    public WsNioClientConnector(WsNioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        String wsUrl = ((WsNioClient)this.client).getConfig().getUrl().replace("-java://", "://");
        this.real = new WebSocketClientImpl(URI.create(wsUrl), (WsNioClient)this.client);
        if (((WsNioClient)this.client).getConfig().getSslContext() != null) {
            this.real.setSocketFactory(((WsNioClient)this.client).getConfig().getSslContext().getSocketFactory());
        }
        if (((WsNioClient)this.client).getConfig().getIdleTimeout() > 0L) {
            this.real.setConnectionLostTimeout((int)(((WsNioClient)this.client).getConfig().getIdleTimeout() / 1000L));
        }
        this.real.setReuseAddr(true);
        this.real.connect();
        try {
            ClientHandshakeResult handshakeResult = this.real.getHandshakeFuture().get(((WsNioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketDConnectionException("Connection timeout: " + ((WsNioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketDConnectionException("Connection failed: " + ((WsNioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    public void close() {
        block3: {
            try {
                if (this.real != null && this.real.isOpen()) {
                    this.real.close();
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Client connector close error", e);
            }
        }
    }
}

