/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Utils;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.handle.Context;

public class CloudTraceServiceImpl
implements CloudTraceService {
    private final ThreadLocal<String> traceIdLocal = FactoryManager.getGlobal().newThreadLocal(CloudTraceServiceImpl.class, false);

    @Override
    public String HEADER_TRACE_ID_NAME() {
        return "X-Solon-Trace-Id";
    }

    @Override
    public String HEADER_FROM_ID_NAME() {
        return "X-Solon-From-Id";
    }

    @Override
    public void setLocalTraceId(String traceId) {
        this.traceIdLocal.set(traceId);
    }

    @Override
    public String getTraceId() {
        Context ctx = Context.current();
        if (ctx == null) {
            String traceId = this.traceIdLocal.get();
            if (Utils.isEmpty((String)traceId)) {
                traceId = Utils.guid();
                this.traceIdLocal.set(traceId);
            }
            return traceId;
        }
        String traceId = ctx.header(this.HEADER_TRACE_ID_NAME());
        if (Utils.isEmpty((String)traceId)) {
            traceId = Utils.guid();
            ctx.headerMap().put(this.HEADER_TRACE_ID_NAME(), (Object)traceId);
        }
        return traceId;
    }

    @Override
    public String getFromId() {
        Context ctx = Context.current();
        if (ctx == null) {
            return "";
        }
        String fromId = ctx.header(this.HEADER_FROM_ID_NAME());
        if (Utils.isEmpty((String)fromId)) {
            fromId = ctx.realIp();
            ctx.headerMap().put(this.HEADER_FROM_ID_NAME(), (Object)fromId);
        }
        return fromId;
    }
}

