/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.model.EventObserverMap;

public class CloudEventObserverManger {
    private Map<String, EventObserverMap> topicObserverMap = new LinkedHashMap<String, EventObserverMap>();

    public int topicSize() {
        return this.topicObserverMap.size();
    }

    public Set<String> topicAll() {
        return this.topicObserverMap.keySet();
    }

    public EventObserverMap topicOf(String topic) {
        return this.topicObserverMap.get(topic);
    }

    public EventObserver getByTopic(String topic) {
        EventObserverMap tmp = this.topicObserverMap.get(topic);
        if (tmp == null) {
            return null;
        }
        return tmp.topicObserver();
    }

    public EventObserver getByTopicAndTag(String topic, String tag) {
        EventObserverMap tmp = this.topicObserverMap.get(topic);
        if (tmp == null) {
            return null;
        }
        return tmp.tagObserver(tag);
    }

    public void add(String topic, EventLevel level, String group, String topicRaw, String tag, int qos, CloudEventHandler handler) {
        EventObserverMap eventObserverMap = this.topicObserverMap.computeIfAbsent(topic, t -> new EventObserverMap(new EventObserver(level, group, topicRaw, tag, qos)));
        eventObserverMap.topicObserver().addHandler(handler);
        if (Utils.isNotEmpty((String)tag)) {
            eventObserverMap.tagObserverIfAbsent(tag, t -> new EventObserver(level, group, topicRaw, tag, qos)).addHandler(handler);
        }
    }
}

