/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardMediumSoftBigDecimalScoreHolder
extends AbstractScoreHolder {
    protected BigDecimal hardScore;
    protected BigDecimal mediumScore;
    protected BigDecimal softScore;

    public HardMediumSoftBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftBigDecimalScore.ZERO);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
        }, () -> HardMediumSoftBigDecimalScore.valueOf(hardWeight, BigDecimal.ZERO, BigDecimal.ZERO));
    }

    public void addMediumConstraintMatch(RuleContext kcontext, BigDecimal mediumWeight) {
        this.mediumScore = this.mediumScore == null ? mediumWeight : this.mediumScore.add(mediumWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
        }, () -> HardMediumSoftBigDecimalScore.valueOf(BigDecimal.ZERO, mediumWeight, BigDecimal.ZERO));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight) {
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.valueOf(BigDecimal.ZERO, BigDecimal.ZERO, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal mediumWeight, BigDecimal softWeight) {
        this.hardScore = this.hardScore == null ? hardWeight : this.hardScore.add(hardWeight);
        this.mediumScore = this.mediumScore == null ? mediumWeight : this.mediumScore.add(mediumWeight);
        this.softScore = this.softScore == null ? softWeight : this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.valueOf(hardWeight, mediumWeight, softWeight));
    }

    @Override
    public Score extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.valueOfUninitialized(initScore, this.hardScore == null ? BigDecimal.ZERO : this.hardScore, this.mediumScore == null ? BigDecimal.ZERO : this.mediumScore, this.softScore == null ? BigDecimal.ZERO : this.softScore);
    }
}

