/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvictionScheduler {
    private static final Logger log = LoggerFactory.getLogger(EvictionScheduler.class);
    private final ConcurrentMap<String, RedissonCacheTask> tasks = PlatformDependent.newConcurrentHashMap();
    private final CommandAsyncExecutor executor;
    private final ConcurrentMap<String, Long> lastExpiredTime = PlatformDependent.newConcurrentHashMap();
    private final int expireTaskExecutionDelay = 1000;
    private final int valuesAmountToClean = 500;

    public EvictionScheduler(CommandAsyncExecutor executor) {
        this.executor = executor;
    }

    public void scheduleCleanMultimap(String name, String timeoutSetName) {
        RedissonCacheTask task = new RedissonCacheTask(name, timeoutSetName, null, true, null);
        RedissonCacheTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            task.schedule();
        }
    }

    public void scheduleJCache(String name, String timeoutSetName, String expiredChannelName) {
        RedissonCacheTask task = new RedissonCacheTask(name, timeoutSetName, null, false, expiredChannelName);
        RedissonCacheTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            task.schedule();
        }
    }

    public void schedule(String name, String timeoutSetName) {
        RedissonCacheTask task = new RedissonCacheTask(name, timeoutSetName, null, false, null);
        RedissonCacheTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            task.schedule();
        }
    }

    public void schedule(String name) {
        this.schedule(name, null);
    }

    public void schedule(String name, String timeoutSetName, String maxIdleSetName) {
        RedissonCacheTask task = new RedissonCacheTask(name, timeoutSetName, maxIdleSetName, false, null);
        RedissonCacheTask prevTask = this.tasks.putIfAbsent(name, task);
        if (prevTask == null) {
            task.schedule();
        }
    }

    public void runCleanTask(final String name, String timeoutSetName, long currentDate) {
        final Long lastExpired = (Long)this.lastExpiredTime.get(name);
        long now = System.currentTimeMillis();
        if (lastExpired == null) {
            if (this.lastExpiredTime.putIfAbsent(name, now) != null) {
                return;
            }
        } else if (lastExpired + 1000L >= now) {
            if (!this.lastExpiredTime.replace(name, lastExpired, now)) {
                return;
            }
        } else {
            return;
        }
        RFuture<Integer> future = this.cleanupExpiredEntires(name, timeoutSetName, null, 500, false, null);
        future.addListener(new FutureListener<Integer>(){

            public void operationComplete(Future<Integer> future) throws Exception {
                EvictionScheduler.this.executor.getConnectionManager().getGroup().schedule(new Runnable(){

                    @Override
                    public void run() {
                        EvictionScheduler.this.lastExpiredTime.remove(name, lastExpired);
                    }
                }, 3000L, TimeUnit.SECONDS);
                if (!future.isSuccess()) {
                    log.warn("Can't execute clean task for expired values. RSetCache name: " + name, future.cause());
                    return;
                }
            }
        });
    }

    private RFuture<Integer> cleanupExpiredEntires(String name, String timeoutSetName, String maxIdleSetName, int keysLimit, boolean multimap, String expiredChannelName) {
        if (multimap) {
            return this.executor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredKeys = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); if #expiredKeys > 0 then redis.call('zrem', KEYS[2], unpack(expiredKeys)); local values = redis.call('hmget', KEYS[1], unpack(expiredKeys)); local keys = {}; for i, v in ipairs(values) do local name = '{' .. KEYS[1] .. '}:' .. v; table.insert(keys, name); end; redis.call('del', unpack(keys)); redis.call('hdel', KEYS[1], unpack(expiredKeys)); end; return #expiredKeys;", Arrays.asList(name, timeoutSetName), System.currentTimeMillis(), keysLimit);
        }
        if (maxIdleSetName != null) {
            return this.executor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredKeys1 = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); if #expiredKeys1 > 0 then redis.call('zrem', KEYS[3], unpack(expiredKeys1)); redis.call('zrem', KEYS[2], unpack(expiredKeys1)); redis.call('hdel', KEYS[1], unpack(expiredKeys1)); end; local expiredKeys2 = redis.call('zrangebyscore', KEYS[3], 0, ARGV[1], 'limit', 0, ARGV[2]); if #expiredKeys2 > 0 then redis.call('zrem', KEYS[3], unpack(expiredKeys2)); redis.call('zrem', KEYS[2], unpack(expiredKeys2)); redis.call('hdel', KEYS[1], unpack(expiredKeys2)); end; return #expiredKeys1 + #expiredKeys2;", Arrays.asList(name, timeoutSetName, maxIdleSetName), System.currentTimeMillis(), keysLimit);
        }
        if (timeoutSetName == null) {
            return this.executor.writeAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.ZREMRANGEBYSCORE, name, 0, System.currentTimeMillis());
        }
        if (expiredChannelName != null) {
            return this.executor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredKeys = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); for i, k in ipairs(expiredKeys) do local v = redis.call('hget', KEYS[1], k);local msg = struct.pack('Lc0Lc0', string.len(tostring(k)), tostring(k), string.len(tostring(v)), tostring(v));redis.call('publish', KEYS[3], msg);end; if #expiredKeys > 0 then redis.call('zrem', KEYS[2], unpack(expiredKeys)); redis.call('hdel', KEYS[1], unpack(expiredKeys)); end; return #expiredKeys;", Arrays.asList(name, timeoutSetName, expiredChannelName), System.currentTimeMillis(), keysLimit);
        }
        return this.executor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredKeys = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, ARGV[2]); if #expiredKeys > 0 then redis.call('zrem', KEYS[2], unpack(expiredKeys)); redis.call('hdel', KEYS[1], unpack(expiredKeys)); end; return #expiredKeys;", Arrays.asList(name, timeoutSetName), System.currentTimeMillis(), keysLimit);
    }

    public class RedissonCacheTask
    implements Runnable {
        final String name;
        final String timeoutSetName;
        final String maxIdleSetName;
        final String expiredChannelName;
        final boolean multimap;
        final Deque<Integer> sizeHistory = new LinkedList<Integer>();
        int delay = 10;
        final int minDelay = 1;
        final int maxDelay = 7200;
        final int keysLimit = 300;

        public RedissonCacheTask(String name, String timeoutSetName, String maxIdleSetName, boolean multimap, String expiredChannelName) {
            this.name = name;
            this.timeoutSetName = timeoutSetName;
            this.maxIdleSetName = maxIdleSetName;
            this.multimap = multimap;
            this.expiredChannelName = expiredChannelName;
        }

        public void schedule() {
            EvictionScheduler.this.executor.getConnectionManager().getGroup().schedule((Runnable)this, (long)this.delay, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            RFuture future = EvictionScheduler.this.cleanupExpiredEntires(this.name, this.timeoutSetName, this.maxIdleSetName, 300, this.multimap, this.expiredChannelName);
            future.addListener(new FutureListener<Integer>(){

                public void operationComplete(Future<Integer> future) throws Exception {
                    if (!future.isSuccess()) {
                        RedissonCacheTask.this.schedule();
                        return;
                    }
                    Integer size = (Integer)future.getNow();
                    if (RedissonCacheTask.this.sizeHistory.size() == 2) {
                        if (RedissonCacheTask.this.sizeHistory.peekFirst() > RedissonCacheTask.this.sizeHistory.peekLast() && RedissonCacheTask.this.sizeHistory.peekLast() > size) {
                            RedissonCacheTask.this.delay = Math.min(7200, (int)((double)RedissonCacheTask.this.delay * 1.5));
                        }
                        if (RedissonCacheTask.this.sizeHistory.peekFirst().intValue() == RedissonCacheTask.this.sizeHistory.peekLast().intValue() && RedissonCacheTask.this.sizeHistory.peekLast().intValue() == size.intValue()) {
                            if (size == 300) {
                                RedissonCacheTask.this.delay = Math.max(1, RedissonCacheTask.this.delay / 4);
                            }
                            if (size == 0) {
                                RedissonCacheTask.this.delay = Math.min(7200, (int)((double)RedissonCacheTask.this.delay * 1.5));
                            }
                        }
                        RedissonCacheTask.this.sizeHistory.pollFirst();
                    }
                    RedissonCacheTask.this.sizeHistory.add(size);
                    RedissonCacheTask.this.schedule();
                }
            });
        }
    }
}

