/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandExecutor;
import org.redisson.pubsub.LockPubSub;

public class RedissonWriteLock
extends RedissonLock
implements RLock {
    private final CommandExecutor commandExecutor;

    protected RedissonWriteLock(CommandExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name, id);
        this.commandExecutor = commandExecutor;
    }

    @Override
    String getChannelName() {
        return "redisson_rwlock__{" + this.getName() + "}";
    }

    @Override
    <T> RFuture<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('hset', KEYS[1], 'mode', 'write'); redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (mode == 'write') then if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; end;return redis.call('pttl', KEYS[1]);", Arrays.asList(this.getName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public void unlock() {
        Boolean opStatus = (Boolean)this.commandExecutor.evalWrite(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local mode = redis.call('hget', KEYS[1], 'mode'); if (mode == false) then redis.call('publish', KEYS[2], ARGV[1]); return 1; end;if (mode == 'write') then local lockExists = redis.call('hexists', KEYS[1], ARGV[3]); if (lockExists == 0) then return nil;else local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('hdel', KEYS[1], ARGV[3]); if (redis.call('hlen', KEYS[1]) == 1) then redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); end; return 1; end; end; end; return nil;", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage, this.internalLockLeaseTime, this.getLockName(Thread.currentThread().getId()));
        if (opStatus == null) {
            throw new IllegalMonitorStateException("attempt to unlock read lock, not locked by current thread by node id: " + this.id + " thread-id: " + Thread.currentThread().getId());
        }
        if (opStatus.booleanValue()) {
            this.cancelExpirationRenewal();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        RFuture<Boolean> result = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hget', KEYS[1], 'mode') == 'write') then redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; else return 0; end;", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage);
        result.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (future.isSuccess() && ((Boolean)future.getNow()).booleanValue()) {
                    RedissonWriteLock.this.cancelExpirationRenewal();
                }
            }
        });
        return result;
    }

    @Override
    public boolean isLocked() {
        String res = (String)this.commandExecutor.write(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.HGET, this.getName(), "mode");
        return "write".equals(res);
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return (Boolean)this.commandExecutor.write(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.getName(), this.getLockName(Thread.currentThread().getId()));
    }

    @Override
    public int getHoldCount() {
        Long res = (Long)this.commandExecutor.write(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HGET, this.getName(), this.getLockName(Thread.currentThread().getId()));
        if (res == null) {
            return 0;
        }
        return res.intValue();
    }
}

