/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.JsonJacksonCodec;

public class JsonJacksonMapValueCodec<T>
extends JsonJacksonCodec {
    private final ObjectMapper mapper;
    private TypeReference<T> typeReference;

    public JsonJacksonMapValueCodec(Class<T> klass) {
        this(new TypeReference<T>(){});
    }

    public JsonJacksonMapValueCodec(TypeReference<T> typeReference) {
        this.typeReference = typeReference;
        this.mapper = new ObjectMapper();
        this.init(this.mapper);
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                return JsonJacksonMapValueCodec.this.mapper.readValue((InputStream)new ByteBufInputStream(buf), JsonJacksonMapValueCodec.this.typeReference);
            }
        };
    }

    @Override
    public Encoder getMapValueEncoder() {
        return new Encoder(){

            @Override
            public byte[] encode(Object in) throws IOException {
                return JsonJacksonMapValueCodec.this.mapper.writeValueAsBytes(in);
            }
        };
    }
}

