/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.ArrayList;
import java.util.List;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.misc.RPromise;

public class CommandsData
implements QueueCommand {
    private final List<CommandData<?, ?>> commands;
    private final RPromise<Void> promise;
    private final boolean noResult;

    public CommandsData(RPromise<Void> promise, List<CommandData<?, ?>> commands) {
        this(promise, commands, false);
    }

    public CommandsData(RPromise<Void> promise, List<CommandData<?, ?>> commands, boolean noResult) {
        this.promise = promise;
        this.commands = commands;
        this.noResult = noResult;
    }

    public RPromise<Void> getPromise() {
        return this.promise;
    }

    public boolean isNoResult() {
        return this.noResult;
    }

    public List<CommandData<?, ?>> getCommands() {
        return this.commands;
    }

    @Override
    public List<CommandData<Object, Object>> getPubSubOperations() {
        ArrayList<CommandData<Object, Object>> result = new ArrayList<CommandData<Object, Object>>();
        for (CommandData<?, ?> commandData : this.commands) {
            if (!PUBSUB_COMMANDS.equals(commandData.getCommand().getName())) continue;
            result.add(commandData);
        }
        return result;
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFailure(cause);
    }
}

