/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.DecoderState;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class NestedMultiDecoder<T>
implements MultiDecoder<Object> {
    protected final MultiDecoder<Object> firstDecoder;
    protected final MultiDecoder<Object> secondDecoder;
    private MultiDecoder<Object> thirdDecoder;
    private boolean handleEmpty;

    public NestedMultiDecoder(MultiDecoder<Object> firstDecoder, MultiDecoder<Object> secondDecoder) {
        this(firstDecoder, secondDecoder, false);
    }

    public NestedMultiDecoder(MultiDecoder<Object> firstDecoder, MultiDecoder<Object> secondDecoder, boolean handleEmpty) {
        this(firstDecoder, secondDecoder, null, handleEmpty);
    }

    public NestedMultiDecoder(MultiDecoder<Object> firstDecoder, MultiDecoder<Object> secondDecoder, MultiDecoder<Object> thirdDecoder) {
        this(firstDecoder, secondDecoder, thirdDecoder, false);
    }

    public NestedMultiDecoder(MultiDecoder<Object> firstDecoder, MultiDecoder<Object> secondDecoder, MultiDecoder<Object> thirdDecoder, boolean handleEmpty) {
        this.firstDecoder = firstDecoder;
        this.secondDecoder = secondDecoder;
        this.thirdDecoder = thirdDecoder;
        this.handleEmpty = handleEmpty;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        NestedDecoderState ds = this.getDecoder(state);
        MultiDecoder<Object> decoder = null;
        if (ds.getFlipDecoderIndex() == 2) {
            decoder = this.firstDecoder;
        }
        if (ds.getFlipDecoderIndex() == 1) {
            decoder = this.secondDecoder;
        }
        return decoder.decode(buf, state);
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        NestedDecoderState ds = this.getDecoder(state);
        if (paramNum == 0) {
            ds.incFlipDecoderIndex();
            ds.resetDecoderIndex();
        }
        if (ds.getFlipDecoderIndex() == 3) {
            ds.resetFlipDecoderIndex();
            ds.incFlipDecoderIndex();
        }
        MultiDecoder<Object> decoder = null;
        if (ds.getFlipDecoderIndex() == 2) {
            decoder = this.firstDecoder;
        }
        if (ds.getFlipDecoderIndex() == 1) {
            decoder = this.secondDecoder;
        }
        return decoder.isApplicable(paramNum, state);
    }

    protected final NestedDecoderState getDecoder(State state) {
        NestedDecoderState ds = (NestedDecoderState)state.getDecoderState();
        if (ds == null) {
            ds = new NestedDecoderState();
            state.setDecoderState(ds);
        }
        return ds;
    }

    @Override
    public Object decode(List<Object> parts, State state) {
        if (parts.isEmpty() && state.getDecoderState() == null && this.handleEmpty) {
            MultiDecoder<Object> decoder = this.secondDecoder;
            if (this.thirdDecoder != null) {
                decoder = this.thirdDecoder;
            }
            return decoder.decode(parts, state);
        }
        NestedDecoderState ds = this.getDecoder(state);
        if (parts.isEmpty()) {
            ds.resetDecoderIndex();
        }
        ds.incDecoderIndex();
        MultiDecoder<Object> decoder = null;
        if (ds.getDecoderIndex() == 1) {
            decoder = this.firstDecoder;
        }
        if (ds.getDecoderIndex() == 2) {
            decoder = this.secondDecoder;
        }
        if (ds.getDecoderIndex() == 3) {
            decoder = this.thirdDecoder;
        }
        return decoder.decode(parts, state);
    }

    public static class NestedDecoderState
    implements DecoderState {
        int decoderIndex;
        int flipDecoderIndex;

        public NestedDecoderState() {
        }

        public NestedDecoderState(int decoderIndex, int flipDecoderIndex) {
            this.decoderIndex = decoderIndex;
            this.flipDecoderIndex = flipDecoderIndex;
        }

        public int getDecoderIndex() {
            return this.decoderIndex;
        }

        public void resetDecoderIndex() {
            this.decoderIndex = 0;
        }

        public void incDecoderIndex() {
            ++this.decoderIndex;
        }

        public int getFlipDecoderIndex() {
            return this.flipDecoderIndex;
        }

        public void resetFlipDecoderIndex() {
            this.flipDecoderIndex = 0;
        }

        public void incFlipDecoderIndex() {
            ++this.flipDecoderIndex;
        }

        @Override
        public DecoderState copy() {
            return new NestedDecoderState(this.decoderIndex, this.flipDecoderIndex);
        }

        public String toString() {
            return "NestedDecoderState [decoderIndex=" + this.decoderIndex + ", flipDecoderIndex=" + this.flipDecoderIndex + "]";
        }
    }
}

