/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class FstCodec
implements Codec {
    private final FSTConfiguration config;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            try {
                ByteBufInputStream in = new ByteBufInputStream(buf);
                FSTObjectInput inputStream = FstCodec.this.config.getObjectInput((InputStream)in);
                return inputStream.readObject();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public byte[] encode(Object in) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FSTObjectOutput oos = FstCodec.this.config.getObjectOutput((OutputStream)os);
            oos.writeObject(in);
            oos.flush();
            return os.toByteArray();
        }
    };

    public FstCodec() {
        this(FSTConfiguration.createDefaultConfiguration());
    }

    public FstCodec(ClassLoader classLoader) {
        this(FstCodec.createConfig(classLoader));
    }

    private static FSTConfiguration createConfig(ClassLoader classLoader) {
        FSTConfiguration def = FSTConfiguration.createDefaultConfiguration();
        def.setClassLoader(classLoader);
        return def;
    }

    public FstCodec(FSTConfiguration fstConfiguration) {
        this.config = fstConfiguration;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

