/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.reactivestreams.Publisher;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;

public class RedissonScoredSortedSetReactive<V>
extends RedissonExpirableReactive
implements RScoredSortedSetReactive<V> {
    public RedissonScoredSortedSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonScoredSortedSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public Publisher<V> pollFirst() {
        return this.poll(0);
    }

    @Override
    public Publisher<V> pollLast() {
        return this.poll(-1);
    }

    private Publisher<V> poll(int index) {
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('zrange', KEYS[1], ARGV[1], ARGV[2]); if v[1] ~= nil then redis.call('zremrangebyrank', KEYS[1], ARGV[1], ARGV[2]); return v[1]; end return nil;", Collections.singletonList(this.getName()), index, index);
    }

    @Override
    public Publisher<V> first() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGE_SINGLE, this.getName(), 0, 0);
    }

    @Override
    public Publisher<V> last() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGE_SINGLE, this.getName(), -1, -1);
    }

    @Override
    public Publisher<Boolean> add(double score, V object) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.ZADD_BOOL, this.getName(), BigDecimal.valueOf(score).toPlainString(), object);
    }

    @Override
    public Publisher<Integer> removeRangeByRank(int startIndex, int endIndex) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.ZREMRANGEBYRANK, this.getName(), startIndex, endIndex);
    }

    @Override
    public Publisher<Integer> removeRangeByScore(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(BigDecimal.valueOf(startScore).toPlainString(), startScoreInclusive);
        String endValue = this.value(BigDecimal.valueOf(endScore).toPlainString(), endScoreInclusive);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.ZREMRANGEBYSCORE, this.getName(), startValue, endValue);
    }

    private String value(String element, boolean inclusive) {
        if (!inclusive) {
            element = "(" + element;
        }
        return element;
    }

    @Override
    public Publisher<Boolean> remove(Object object) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.ZREM, this.getName(), object);
    }

    @Override
    public Publisher<Long> size() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZCARD, this.getName());
    }

    @Override
    public Publisher<Boolean> contains(Object o) {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZSCORE_CONTAINS, this.getName(), o);
    }

    @Override
    public Publisher<Double> getScore(V o) {
        return this.commandExecutor.readReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.ZSCORE, this.getName(), o);
    }

    @Override
    public Publisher<Long> rank(V o) {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANK, this.getName(), o);
    }

    private Publisher<ListScanResult<V>> scanIteratorReactive(InetSocketAddress client, long startPos) {
        return this.commandExecutor.readReactive(client, this.getName(), this.codec, RedisCommands.ZSCAN, this.getName(), startPos);
    }

    @Override
    public Publisher<V> iterator() {
        return new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<V>> scanIteratorReactive(InetSocketAddress client, long nextIterPos) {
                return RedissonScoredSortedSetReactive.this.scanIteratorReactive(client, nextIterPos);
            }
        };
    }

    @Override
    public Publisher<Boolean> containsAll(Collection<?> c) {
        return this.commandExecutor.evalReadReactive(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, RedisCommand.ValueType.OBJECTS), "local s = redis.call('zrange', KEYS[1], 0, -1);for i = 1, table.getn(s), 1 do for j = 1, table.getn(ARGV), 1 do if ARGV[j] == s[i] then table.remove(ARGV, j) end end; end;return table.getn(ARGV) == 0 and 1 or 0; ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public Publisher<Boolean> removeAll(Collection<?> c) {
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, RedisCommand.ValueType.OBJECTS), "local v = 0 for i = 1, table.getn(ARGV), 1 do if redis.call('zrem', KEYS[1], ARGV[i]) == 1 then v = 1 end end return v ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public Publisher<Boolean> retainAll(Collection<?> c) {
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, RedisCommand.ValueType.OBJECTS), "local changed = 0 local s = redis.call('zrange', KEYS[1], 0, -1) local i = 1 while i <= table.getn(s) do local element = s[i] local isInAgrs = false for j = 1, table.getn(ARGV), 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('zrem', KEYS[1], element) changed = 1 end i = i + 1 end return changed ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public Publisher<Double> addScore(V object, Number value) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZINCRBY, this.getName(), new BigDecimal(value.toString()).toPlainString(), object);
    }

    @Override
    public Publisher<Collection<V>> valueRange(int startIndex, int endIndex) {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGE, this.getName(), startIndex, endIndex);
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRange(int startIndex, int endIndex) {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGE_ENTRY, this.getName(), startIndex, endIndex, "WITHSCORES");
    }

    @Override
    public Publisher<Collection<V>> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(BigDecimal.valueOf(startScore).toPlainString(), startScoreInclusive);
        String endValue = this.value(BigDecimal.valueOf(endScore).toPlainString(), endScoreInclusive);
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_LIST, this.getName(), startValue, endValue);
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(BigDecimal.valueOf(startScore).toPlainString(), startScoreInclusive);
        String endValue = this.value(BigDecimal.valueOf(endScore).toPlainString(), endScoreInclusive);
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_ENTRY, this.getName(), startValue, endValue, "WITHSCORES");
    }

    @Override
    public Publisher<Collection<V>> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(BigDecimal.valueOf(startScore).toPlainString(), startScoreInclusive);
        String endValue = this.value(BigDecimal.valueOf(endScore).toPlainString(), endScoreInclusive);
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_LIST, this.getName(), startValue, endValue, "LIMIT", offset, count);
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(BigDecimal.valueOf(startScore).toPlainString(), startScoreInclusive);
        String endValue = this.value(BigDecimal.valueOf(endScore).toPlainString(), endScoreInclusive);
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_ENTRY, this.getName(), startValue, endValue, "WITHSCORES", "LIMIT", offset, count);
    }
}

