/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.ScanIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.mapreduce.RedissonCollectionMapReduce;

public class RedissonSetCache<V>
extends RedissonExpirable
implements RSetCache<V>,
ScanIterator {
    RedissonClient redisson;

    public RedissonSetCache(EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getName(), 0L);
        }
        this.redisson = redisson;
    }

    public RedissonSetCache(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getName(), 0L);
        }
        this.redisson = redisson;
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor.getConnectionManager());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZCARD_INT, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(o), this.codec, new RedisStrictCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5), "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;else return 1;end;else return 0;end; ", Arrays.asList(this.getName(o)), System.currentTimeMillis(), o);
    }

    @Override
    public ListScanResult<ScanObjectEntry> scanIterator(String name, InetSocketAddress client, long startPos, String pattern) {
        RFuture<ListScanResult<ScanObjectEntry>> f = this.scanIteratorAsync(name, client, startPos, pattern);
        return this.get(f);
    }

    public RFuture<ListScanResult<ScanObjectEntry>> scanIteratorAsync(String name, InetSocketAddress client, long startPos, String pattern) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(startPos);
        params.add(System.currentTimeMillis());
        if (pattern != null) {
            params.add(pattern);
        }
        return this.commandExecutor.evalReadAsync(client, name, new ScanCodec(this.codec), RedisCommands.EVAL_ZSCAN, "local result = {}; local res; if (#ARGV == 3) then  res = redis.call('zscan', KEYS[1], ARGV[1], 'match', ARGV[3]); else  res = redis.call('zscan', KEYS[1], ARGV[1]); end;for i, value in ipairs(res[2]) do if i % 2 == 0 then local expireDate = value; if tonumber(expireDate) > tonumber(ARGV[2]) then table.insert(result, res[2][i-1]); end; end;end;return {res[1], result};", Arrays.asList(name), params.toArray());
    }

    @Override
    public Iterator<V> iterator(final String pattern) {
        return new RedissonBaseIterator<V>(){

            @Override
            ListScanResult<ScanObjectEntry> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonSetCache.this.scanIterator(RedissonSetCache.this.getName(), client, nextIterPos, pattern);
            }

            @Override
            void remove(V value) {
                RedissonSetCache.this.remove(value);
            }
        };
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE, this.getName(), System.currentTimeMillis(), 92233720368547758L);
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public boolean add(V value, long ttl, TimeUnit unit) {
        return this.get(this.addAsync(value, ttl, unit));
    }

    @Override
    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit unit) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("TTL can't be negative");
        }
        if (ttl == 0L) {
            return this.addAsync(value);
        }
        if (unit == null) {
            throw new NullPointerException("TimeUnit param can't be null");
        }
        ByteBuf objectState = this.encode(value);
        long timeoutDate = System.currentTimeMillis() + unit.toMillis(ttl);
        return this.commandExecutor.evalWriteAsync(this.getName(value), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0;end; return 1; ", Arrays.asList(this.getName(value)), System.currentTimeMillis(), timeoutDate, objectState);
    }

    @Override
    public RFuture<Boolean> addAsync(V value) {
        return this.addAsync(value, 92233720368547758L - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.commandExecutor.writeAsync(this.getName(o), this.codec, RedisCommands.ZREM, this.getName(o), o);
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(true);
        }
        ArrayList<Long> params = new ArrayList<Long>(c.size() + 1);
        params.add(System.currentTimeMillis());
        params.addAll(c);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS), "for j = 2, #ARGV, 1 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[j]) if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;end; else return 0;end; end; return 1; ", Collections.singletonList(this.getName()), params.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2 + 1);
        params.add(this.getName());
        for (V value : c) {
            ByteBuf objectState = this.encode(value);
            params.add(score);
            params.add(objectState);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZADD_BOOL_RAW, params.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Long> params = new ArrayList<Long>(c.size() * 2);
        for (Object object : c) {
            params.add(score);
            params.add((Long)this.encode(object));
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('zadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('zcard', KEYS[1]); local size = redis.call('zinterstore', KEYS[1], #ARGV/2, KEYS[1], KEYS[2], 'aggregate', 'min');redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getName(), "redisson_temp__{" + this.getName() + "}"), params.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<String> params = new ArrayList<String>(c.size() + 1);
        params.add(this.getName());
        params.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREM, params.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public void clear() {
        this.delete();
    }
}

