/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class MapCacheEventCodec
implements Codec {
    private final Codec codec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>(3);
            Object key = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapKeyDecoder());
            result.add(key);
            Object value = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapValueDecoder());
            result.add(value);
            if (buf.isReadable()) {
                Object oldValue = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapValueDecoder());
                result.add(oldValue);
            }
            return result;
        }
    };

    public MapCacheEventCodec(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        throw new UnsupportedOperationException();
    }

    private Object decode(ByteBuf buf, State state, Decoder<?> decoder) throws IOException {
        int keyLen = PlatformDependent.isWindows() ? buf.readIntLE() : (int)buf.readLongLE();
        ByteBuf keyBuf = buf.readSlice(keyLen);
        Object key = decoder.decode(keyBuf, state);
        return key;
    }
}

