/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.SubscribeListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;

public class PubSubConnectionEntry {
    private final AtomicInteger subscribedChannelsAmount;
    private final RedisPubSubConnection conn;
    private final ConcurrentMap<String, SubscribeListener> subscribeChannelListeners = new ConcurrentHashMap<String, SubscribeListener>();
    private final ConcurrentMap<String, Queue<RedisPubSubListener<?>>> channelListeners = new ConcurrentHashMap();

    public PubSubConnectionEntry(RedisPubSubConnection conn, int subscriptionsPerConnection) {
        this.conn = conn;
        this.subscribedChannelsAmount = new AtomicInteger(subscriptionsPerConnection);
    }

    public boolean hasListeners(String channelName) {
        return this.channelListeners.containsKey(channelName);
    }

    public Collection<RedisPubSubListener<?>> getListeners(String channelName) {
        Collection result = (Collection)this.channelListeners.get(channelName);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String channelName, RedisPubSubListener<?> listener) {
        Queue oldQueue;
        if (listener == null) {
            return;
        }
        Queue<RedisPubSubListener<Object>> queue = (ConcurrentLinkedQueue)this.channelListeners.get(channelName);
        if (queue == null && (oldQueue = (Queue)this.channelListeners.putIfAbsent(channelName, queue = new ConcurrentLinkedQueue())) != null) {
            queue = oldQueue;
        }
        boolean deleted = false;
        ConcurrentLinkedQueue concurrentLinkedQueue = queue;
        synchronized (concurrentLinkedQueue) {
            if (this.channelListeners.get(channelName) != queue) {
                deleted = true;
            } else {
                queue.add(listener);
            }
        }
        if (deleted) {
            this.addListener(channelName, listener);
            return;
        }
        this.conn.addListener(listener);
    }

    public boolean removeAllListeners(String channelName) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            this.removeListener(channelName, listener);
        }
        return !listeners.isEmpty();
    }

    public boolean removeListener(String channelName, EventListener msgListener) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (listener instanceof PubSubMessageListener && ((PubSubMessageListener)listener).getListener() == msgListener) {
                this.removeListener(channelName, listener);
                return true;
            }
            if (!(listener instanceof PubSubPatternMessageListener) || ((PubSubPatternMessageListener)listener).getListener() != msgListener) continue;
            this.removeListener(channelName, listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(String channelName, int listenerId) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (System.identityHashCode(listener) != listenerId) continue;
            this.removeListener(channelName, listener);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(String channelName, RedisPubSubListener<?> listener) {
        Queue queue;
        Queue queue2 = queue = (Queue)this.channelListeners.get(channelName);
        synchronized (queue2) {
            if (queue.remove(listener) && queue.isEmpty()) {
                this.channelListeners.remove(channelName);
            }
        }
        this.conn.removeListener(listener);
    }

    public int tryAcquire() {
        int value;
        do {
            if ((value = this.subscribedChannelsAmount.get()) != 0) continue;
            return -1;
        } while (!this.subscribedChannelsAmount.compareAndSet(value, value - 1));
        return value - 1;
    }

    public int release() {
        return this.subscribedChannelsAmount.incrementAndGet();
    }

    public void subscribe(Codec codec, String channelName) {
        this.conn.subscribe(codec, channelName);
    }

    public void psubscribe(Codec codec, String pattern) {
        this.conn.psubscribe(codec, pattern);
    }

    private SubscribeListener addSubscribeListener(String channel, PubSubType type) {
        SubscribeListener subscribeListener = new SubscribeListener(channel, type);
        SubscribeListener oldSubscribeListener = this.subscribeChannelListeners.putIfAbsent(channel, subscribeListener);
        if (oldSubscribeListener != null) {
            return oldSubscribeListener;
        }
        this.conn.addListener(subscribeListener);
        return subscribeListener;
    }

    public Future<Void> getSubscribeFuture(String channel, PubSubType type) {
        SubscribeListener listener = (SubscribeListener)this.subscribeChannelListeners.get(channel);
        if (listener == null) {
            listener = this.addSubscribeListener(channel, type);
        }
        return listener.getSuccessFuture();
    }

    public void unsubscribe(final String channel, final RedisPubSubListener<?> listener) {
        this.conn.addListener(new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, String ch) {
                if (type == PubSubType.UNSUBSCRIBE && channel.equals(ch)) {
                    PubSubConnectionEntry.this.conn.removeListener(this);
                    PubSubConnectionEntry.this.removeListeners(channel);
                    if (listener != null) {
                        listener.onStatus(type, channel);
                    }
                    return true;
                }
                return false;
            }
        });
        this.conn.unsubscribe(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners(String channel) {
        this.conn.removeDisconnectListener(channel);
        SubscribeListener s = (SubscribeListener)this.subscribeChannelListeners.remove(channel);
        this.conn.removeListener(s);
        Queue queue = (Queue)this.channelListeners.get(channel);
        if (queue != null) {
            Queue queue2 = queue;
            synchronized (queue2) {
                this.channelListeners.remove(channel);
            }
            for (RedisPubSubListener listener : queue) {
                this.conn.removeListener(listener);
            }
        }
    }

    public void punsubscribe(final String channel, final RedisPubSubListener<?> listener) {
        this.conn.addListener(new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, String ch) {
                if (type == PubSubType.PUNSUBSCRIBE && channel.equals(ch)) {
                    PubSubConnectionEntry.this.conn.removeListener(this);
                    PubSubConnectionEntry.this.removeListeners(channel);
                    if (listener != null) {
                        listener.onStatus(type, channel);
                    }
                    return true;
                }
                return false;
            }
        });
        this.conn.punsubscribe(channel);
    }

    public RedisPubSubConnection getConnection() {
        return this.conn;
    }
}

