/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.pool.PubSubConnectionPool;
import org.redisson.connection.pool.SlaveConnectionPool;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionManager connectionManager;
    private final PubSubConnectionPool pubSubConnectionPool;
    private final SlaveConnectionPool slaveConnectionPool;
    private final Map<String, ClientConnectionsEntry> ip2Entry = PlatformDependent.newConcurrentHashMap();

    public LoadBalancerManager(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry entry) {
        this.connectionManager = connectionManager;
        this.slaveConnectionPool = new SlaveConnectionPool(config, connectionManager, entry);
        this.pubSubConnectionPool = new PubSubConnectionPool(config, connectionManager, entry);
    }

    public void changeType(InetSocketAddress addr, NodeType nodeType) {
        ClientConnectionsEntry entry = this.ip2Entry.get(this.convert(addr));
        this.changeType(addr, nodeType, entry);
    }

    protected void changeType(Object addr, NodeType nodeType, ClientConnectionsEntry entry) {
        if (entry != null) {
            if (this.connectionManager.isClusterMode()) {
                entry.getClient().getConfig().setReadOnly(nodeType == NodeType.SLAVE && this.connectionManager.getConfig().getReadMode() != ReadMode.MASTER);
            }
            entry.setNodeType(nodeType);
        }
    }

    public void changeType(URI address, NodeType nodeType) {
        ClientConnectionsEntry entry = this.getEntry(address);
        this.changeType(address, nodeType, entry);
    }

    public RFuture<Void> add(final ClientConnectionsEntry entry) {
        final RPromise<Void> result = this.connectionManager.newPromise();
        FutureListener<Void> listener = new FutureListener<Void>(){
            AtomicInteger counter = new AtomicInteger(2);

            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (this.counter.decrementAndGet() == 0) {
                    String addr = entry.getClient().getIpAddr();
                    LoadBalancerManager.this.ip2Entry.put(addr, entry);
                    result.trySuccess(null);
                }
            }
        };
        RFuture slaveFuture = this.slaveConnectionPool.add(entry);
        slaveFuture.addListener(listener);
        RFuture pubSubFuture = this.pubSubConnectionPool.add(entry);
        pubSubFuture.addListener(listener);
        return result;
    }

    public int getAvailableClients() {
        int count = 0;
        for (ClientConnectionsEntry connectionEntry : this.ip2Entry.values()) {
            if (connectionEntry.isFreezed()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unfreeze(URI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.getEntry(address);
        if (entry == null) {
            throw new IllegalStateException("Can't find " + address + " in slaves!");
        }
        ClientConnectionsEntry clientConnectionsEntry = entry;
        synchronized (clientConnectionsEntry) {
            if (!entry.isFreezed()) {
                return false;
            }
            if (freezeReason == ClientConnectionsEntry.FreezeReason.RECONNECT && entry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT || freezeReason != ClientConnectionsEntry.FreezeReason.RECONNECT) {
                entry.resetFailedAttempts();
                entry.setFreezed(false);
                entry.setFreezeReason(null);
                return true;
            }
        }
        return false;
    }

    private String convert(URI address) {
        InetSocketAddress addr = new InetSocketAddress(address.getHost(), address.getPort());
        return this.convert(addr);
    }

    public ClientConnectionsEntry freeze(URI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry connectionEntry = this.getEntry(address);
        return this.freeze(connectionEntry, freezeReason);
    }

    private ClientConnectionsEntry getEntry(URI address) {
        String addr = this.convert(address);
        return this.ip2Entry.get(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConnectionsEntry freeze(ClientConnectionsEntry connectionEntry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (connectionEntry == null) {
            return null;
        }
        ClientConnectionsEntry clientConnectionsEntry = connectionEntry;
        synchronized (clientConnectionsEntry) {
            if (connectionEntry.getFreezeReason() == null || connectionEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT) {
                connectionEntry.setFreezed(true);
                connectionEntry.setFreezeReason(freezeReason);
                return connectionEntry;
            }
            if (connectionEntry.isFreezed()) {
                return null;
            }
        }
        return connectionEntry;
    }

    public RFuture<RedisPubSubConnection> nextPubSubConnection() {
        return this.pubSubConnectionPool.get();
    }

    public boolean contains(InetSocketAddress addr) {
        return this.ip2Entry.containsKey(this.convert(addr));
    }

    protected String convert(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public boolean contains(String addr) {
        return this.ip2Entry.containsKey(addr);
    }

    public RFuture<RedisConnection> getConnection(RedisCommand<?> command, InetSocketAddress addr) {
        ClientConnectionsEntry entry = this.ip2Entry.get(this.convert(addr));
        if (entry != null) {
            return this.slaveConnectionPool.get((RedisCommand)command, entry);
        }
        RedisConnectionException exception = new RedisConnectionException("Can't find entry for " + addr);
        return this.connectionManager.newFailedFuture(exception);
    }

    public RFuture<RedisConnection> nextConnection(RedisCommand<?> command) {
        return this.slaveConnectionPool.get((RedisCommand)command);
    }

    public void returnPubSubConnection(RedisPubSubConnection connection) {
        ClientConnectionsEntry entry = this.ip2Entry.get(this.convert(connection.getRedisClient().getAddr()));
        this.pubSubConnectionPool.returnConnection(entry, connection);
    }

    public void returnConnection(RedisConnection connection) {
        ClientConnectionsEntry entry = this.ip2Entry.get(this.convert(connection.getRedisClient().getAddr()));
        this.slaveConnectionPool.returnConnection(entry, connection);
    }

    public void shutdown() {
        for (ClientConnectionsEntry entry : this.ip2Entry.values()) {
            entry.getClient().shutdown();
        }
    }

    public void shutdownAsync() {
        for (ClientConnectionsEntry entry : this.ip2Entry.values()) {
            this.connectionManager.shutdownAsync(entry.getClient());
        }
    }
}

