/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RScheduledExecutorService;

public class RedissonCompletionService<V>
implements CompletionService<V> {
    protected final RScheduledExecutorService executorService;
    protected final BlockingQueue<RFuture<V>> completionQueue;

    public RedissonCompletionService(RScheduledExecutorService executorService) {
        this(executorService, null);
    }

    public RedissonCompletionService(RScheduledExecutorService executorService, BlockingQueue<RFuture<V>> completionQueue) {
        if (executorService == null) {
            throw new NullPointerException("executorService can't be null");
        }
        this.executorService = executorService;
        if (completionQueue == null) {
            completionQueue = new LinkedBlockingQueue<RFuture<V>>();
        }
        this.completionQueue = completionQueue;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException("taks can't be null");
        }
        Future f = this.executorService.submit((Callable)task);
        f.addListener(new FutureListener<V>((RFuture)f){
            final /* synthetic */ RFuture val$f;
            {
                this.val$f = rFuture;
            }

            public void operationComplete(io.netty.util.concurrent.Future<V> future) throws Exception {
                RedissonCompletionService.this.completionQueue.add(this.val$f);
            }
        });
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException("taks can't be null");
        }
        Future f = this.executorService.submit(task, result);
        f.addListener(new FutureListener<V>((RFuture)f){
            final /* synthetic */ RFuture val$f;
            {
                this.val$f = rFuture;
            }

            public void operationComplete(io.netty.util.concurrent.Future<V> future) throws Exception {
                RedissonCompletionService.this.completionQueue.add(this.val$f);
            }
        });
        return f;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }
}

