/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.api.RFuture;
import reactor.core.support.Exceptions;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class NettyFuturePublisher<T>
extends Stream<T> {
    private final Supplier<RFuture<T>> supplier;

    public NettyFuturePublisher(Supplier<RFuture<T>> supplier) {
        this.supplier = supplier;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe((Subscription)new ReactiveSubscription<T>(this, subscriber){

                protected void onRequest(long n) {
                    ((RFuture)NettyFuturePublisher.this.supplier.get()).addListener(new FutureListener<T>(){

                        public void operationComplete(Future<T> future) throws Exception {
                            if (!future.isSuccess()) {
                                this.onError(future.cause());
                                return;
                            }
                            if (future.getNow() != null) {
                                this.onNext(future.getNow());
                            }
                            this.onComplete();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal((Throwable)throwable);
            subscriber.onError(throwable);
        }
    }
}

