/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.RedissonKeys;
import org.redisson.api.RFuture;
import org.redisson.api.RKeysReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandReactiveService;
import org.redisson.connection.MasterSlaveEntry;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.Streams;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonKeysReactive
implements RKeysReactive {
    private final CommandReactiveService commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysReactive(CommandReactiveService commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    @Override
    public Publisher<Integer> getSlot(final String key) {
        return this.commandExecutor.reactive(new Supplier<RFuture<Integer>>(){

            public RFuture<Integer> get() {
                return RedissonKeysReactive.this.instance.getSlotAsync(key);
            }
        });
    }

    @Override
    public Publisher<String> getKeysByPattern(String pattern) {
        ArrayList<Publisher<String>> publishers = new ArrayList<Publisher<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, pattern));
        }
        return Streams.merge(publishers);
    }

    @Override
    public Publisher<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    private Publisher<ListScanResult<String>> scanIterator(MasterSlaveEntry entry, long startPos, String pattern) {
        if (pattern == null) {
            return this.commandExecutor.writeReactive(entry, (Codec)StringCodec.INSTANCE, RedisCommands.SCAN, startPos);
        }
        return this.commandExecutor.writeReactive(entry, (Codec)StringCodec.INSTANCE, RedisCommands.SCAN, startPos, "MATCH", pattern);
    }

    private Publisher<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern) {
        return new Stream<String>(){

            public void subscribe(Subscriber<? super String> t) {
                t.onSubscribe((Subscription)new ReactiveSubscription<String>((Stream)this, t){
                    private List<String> firstValues;
                    private long nextIterPos;
                    private long currentIndex;

                    protected void onRequest(long n) {
                        this.currentIndex = n;
                        this.nextValues();
                    }

                    protected void nextValues() {
                        final 1 m = this;
                        RedissonKeysReactive.this.scanIterator(entry, this.nextIterPos, pattern).subscribe((Subscriber)new Subscriber<ListScanResult<String>>(){

                            public void onSubscribe(Subscription s) {
                                s.request(Long.MAX_VALUE);
                            }

                            public void onNext(ListScanResult<String> res) {
                                long prevIterPos = nextIterPos;
                                if (nextIterPos == 0L && firstValues == null) {
                                    firstValues = res.getValues();
                                } else if (res.getValues().equals(firstValues)) {
                                    m.onComplete();
                                    currentIndex = 0L;
                                    return;
                                }
                                nextIterPos = res.getPos();
                                if (prevIterPos == nextIterPos) {
                                    nextIterPos = -1L;
                                }
                                for (String val : res.getValues()) {
                                    m.onNext((Object)val);
                                    currentIndex--;
                                    if (currentIndex != 0L) continue;
                                    m.onComplete();
                                    return;
                                }
                                if (nextIterPos == -1L) {
                                    m.onComplete();
                                    currentIndex = 0L;
                                }
                            }

                            public void onError(Throwable error) {
                                m.onError(error);
                            }

                            public void onComplete() {
                                if (currentIndex == 0L) {
                                    return;
                                }
                                this.nextValues();
                            }
                        });
                    }
                });
            }
        };
    }

    @Override
    public Publisher<Collection<String>> findKeysByPattern(final String pattern) {
        return this.commandExecutor.reactive(new Supplier<RFuture<Collection<String>>>(){

            public RFuture<Collection<String>> get() {
                return RedissonKeysReactive.this.instance.findKeysByPatternAsync(pattern);
            }
        });
    }

    @Override
    public Publisher<String> randomKey() {
        return this.commandExecutor.reactive(new Supplier<RFuture<String>>(){

            public RFuture<String> get() {
                return RedissonKeysReactive.this.instance.randomKeyAsync();
            }
        });
    }

    @Override
    public Publisher<Long> deleteByPattern(final String pattern) {
        return this.commandExecutor.reactive(new Supplier<RFuture<Long>>(){

            public RFuture<Long> get() {
                return RedissonKeysReactive.this.instance.deleteByPatternAsync(pattern);
            }
        });
    }

    @Override
    public Publisher<Long> delete(final String ... keys) {
        return this.commandExecutor.reactive(new Supplier<RFuture<Long>>(){

            public RFuture<Long> get() {
                return RedissonKeysReactive.this.instance.deleteAsync(keys);
            }
        });
    }

    @Override
    public Publisher<Void> flushdb() {
        return this.commandExecutor.reactive(new Supplier<RFuture<Void>>(){

            public RFuture<Void> get() {
                return RedissonKeysReactive.this.instance.flushdbAsync();
            }
        });
    }

    @Override
    public Publisher<Void> flushall() {
        return this.commandExecutor.reactive(new Supplier<RFuture<Void>>(){

            public RFuture<Void> get() {
                return RedissonKeysReactive.this.instance.flushallAsync();
            }
        });
    }
}

