/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.api.MapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RMapAsync;
import org.redisson.api.RMapReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.MapScanCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.MapReactive;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.RedissonMapReactiveIterator;
import reactor.fn.BiFunction;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.rx.Streams;

public class RedissonMapReactive<K, V>
extends RedissonExpirableReactive
implements RMapReactive<K, V>,
MapReactive<K, V> {
    private final RMapAsync<K, V> instance;

    public RedissonMapReactive(CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options) {
        super(commandExecutor, name);
        this.instance = new RedissonMap<K, V>(this.codec, commandExecutor, name, null, options);
    }

    public RedissonMapReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, MapOptions<K, V> options) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonMap<K, V>(codec, commandExecutor, name, null, options);
    }

    @Override
    public Publisher<Void> loadAll(final boolean replaceExistingValues, final int parallelism) {
        return this.reactive((Supplier)new Supplier<RFuture<Void>>(){

            public RFuture<Void> get() {
                return RedissonMapReactive.this.instance.loadAllAsync(replaceExistingValues, parallelism);
            }
        });
    }

    @Override
    public Publisher<Void> loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final int parallelism) {
        return this.reactive((Supplier)new Supplier<RFuture<Void>>(){

            public RFuture<Void> get() {
                return RedissonMapReactive.this.instance.loadAllAsync(keys, replaceExistingValues, parallelism);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPutIfAbsent(final K key, final V value) {
        return this.reactive((Supplier)new Supplier<RFuture<Boolean>>(){

            public RFuture<Boolean> get() {
                return RedissonMapReactive.this.instance.fastPutIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Set<K>> readAllKeySet() {
        return this.reactive(new Supplier<RFuture<Set<K>>>(){

            public RFuture<Set<K>> get() {
                return RedissonMapReactive.this.instance.readAllKeySetAsync();
            }
        });
    }

    @Override
    public Publisher<Collection<V>> readAllValues() {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            public RFuture<Collection<V>> get() {
                return RedissonMapReactive.this.instance.readAllValuesAsync();
            }
        });
    }

    @Override
    public Publisher<Set<Map.Entry<K, V>>> readAllEntrySet() {
        return this.reactive(new Supplier<RFuture<Set<Map.Entry<K, V>>>>(){

            public RFuture<Set<Map.Entry<K, V>>> get() {
                return RedissonMapReactive.this.instance.readAllEntrySetAsync();
            }
        });
    }

    @Override
    public Publisher<Map<K, V>> readAllMap() {
        return this.reactive(new Supplier<RFuture<Map<K, V>>>(){

            public RFuture<Map<K, V>> get() {
                return RedissonMapReactive.this.instance.readAllMapAsync();
            }
        });
    }

    @Override
    public Publisher<Integer> valueSize(final K key) {
        return this.reactive((Supplier)new Supplier<RFuture<Integer>>(){

            public RFuture<Integer> get() {
                return RedissonMapReactive.this.instance.valueSizeAsync(key);
            }
        });
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive((Supplier)new Supplier<RFuture<Integer>>(){

            public RFuture<Integer> get() {
                return RedissonMapReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> containsKey(final Object key) {
        return this.reactive((Supplier)new Supplier<RFuture<Boolean>>(){

            public RFuture<Boolean> get() {
                return RedissonMapReactive.this.instance.containsKeyAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsValue(final Object value) {
        return this.reactive((Supplier)new Supplier<RFuture<Boolean>>(){

            public RFuture<Boolean> get() {
                return RedissonMapReactive.this.instance.containsValueAsync(value);
            }
        });
    }

    @Override
    public Publisher<Map<K, V>> getAll(final Set<K> keys) {
        return this.reactive(new Supplier<RFuture<Map<K, V>>>(){

            public RFuture<Map<K, V>> get() {
                return RedissonMapReactive.this.instance.getAllAsync(keys);
            }
        });
    }

    @Override
    public Publisher<Void> putAll(final Map<? extends K, ? extends V> map) {
        return this.reactive((Supplier)new Supplier<RFuture<Void>>(){

            public RFuture<Void> get() {
                return RedissonMapReactive.this.instance.putAllAsync(map);
            }
        });
    }

    @Override
    public Publisher<V> putIfAbsent(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            public RFuture<V> get() {
                return RedissonMapReactive.this.instance.putIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object key, final Object value) {
        return this.reactive((Supplier)new Supplier<RFuture<Boolean>>(){

            public RFuture<Boolean> get() {
                return RedissonMapReactive.this.instance.removeAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> replace(final K key, final V oldValue, final V newValue) {
        return this.reactive((Supplier)new Supplier<RFuture<Boolean>>(){

            public RFuture<Boolean> get() {
                return RedissonMapReactive.this.instance.replaceAsync(key, oldValue, newValue);
            }
        });
    }

    @Override
    public Publisher<V> replace(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            public RFuture<V> get() {
                return RedissonMapReactive.this.instance.replaceAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> get(final K key) {
        return this.reactive(new Supplier<RFuture<V>>(){

            public RFuture<V> get() {
                return RedissonMapReactive.this.instance.getAsync(key);
            }
        });
    }

    @Override
    public Publisher<V> put(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            public RFuture<V> get() {
                return RedissonMapReactive.this.instance.putAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<V> remove(final K key) {
        return this.reactive(new Supplier<RFuture<V>>(){

            public RFuture<V> get() {
                return RedissonMapReactive.this.instance.removeAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> fastPut(final K key, final V value) {
        return this.reactive((Supplier)new Supplier<RFuture<Boolean>>(){

            public RFuture<Boolean> get() {
                return RedissonMapReactive.this.instance.fastPutAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Long> fastRemove(final K ... keys) {
        return this.reactive((Supplier)new Supplier<RFuture<Long>>(){

            public RFuture<Long> get() {
                return RedissonMapReactive.this.instance.fastRemoveAsync(keys);
            }
        });
    }

    @Override
    public Publisher<MapScanResult<ScanObjectEntry, ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long startPos) {
        return this.commandExecutor.readReactive(client, this.getName(), new MapScanCodec(this.codec), RedisCommands.HSCAN, this.getName(), startPos);
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator() {
        return new RedissonMapReactiveIterator(this).stream();
    }

    @Override
    public Publisher<V> valueIterator() {
        return new RedissonMapReactiveIterator<K, V, V>(this){

            @Override
            V getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getValue().getObj();
            }
        }.stream();
    }

    @Override
    public Publisher<K> keyIterator() {
        return new RedissonMapReactiveIterator<K, V, K>(this){

            @Override
            K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getKey().getObj();
            }
        }.stream();
    }

    @Override
    public Publisher<V> addAndGet(final K key, final Number value) {
        return this.reactive(new Supplier<RFuture<V>>(){

            public RFuture<V> get() {
                return RedissonMapReactive.this.instance.addAndGetAsync(key, value);
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.size() != ((Integer)Streams.create(this.size()).next().poll()).intValue()) {
                return false;
            }
            return (Boolean)Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce((Object)true, this.booleanAnd()).next().poll();
        }
        if (o instanceof RMapReactive) {
            RMapReactive m = (RMapReactive)o;
            if (Streams.create(m.size()).next().poll() != Streams.create(this.size()).next().poll()) {
                return false;
            }
            return (Boolean)Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce((Object)true, this.booleanAnd()).next().poll();
        }
        return true;
    }

    private BiFunction<Boolean, Boolean, Boolean> booleanAnd() {
        return new BiFunction<Boolean, Boolean, Boolean>(){

            public Boolean apply(Boolean t, Boolean u) {
                return t & u;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final Map<?, ?> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                    return false;
                }
                return true;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final RMapReactive<Object, Object> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? Streams.create(m.get(key)).next().poll() != null || (Boolean)Streams.create(m.containsKey(key)).next().poll() == false : !value.equals(Streams.create(m.get(key)).next().poll())) {
                    return false;
                }
                return true;
            }
        };
    }

    public int hashCode() {
        return (Integer)Streams.create(this.entryIterator()).map(new Function<Map.Entry<K, V>, Integer>(){

            public Integer apply(Map.Entry<K, V> t) {
                return t.hashCode();
            }
        }).reduce((Object)0, (BiFunction)new BiFunction<Integer, Integer, Integer>(){

            public Integer apply(Integer t, Integer u) {
                return t + u;
            }
        }).next().poll();
    }
}

