/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.reactive.MapReactive;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonMapReactiveIterator<K, V, M> {
    private final MapReactive<K, V> map;

    public RedissonMapReactiveIterator(MapReactive<K, V> map) {
        this.map = map;
    }

    public Publisher<M> stream() {
        return new Stream<M>(){

            public void subscribe(Subscriber<? super M> t) {
                t.onSubscribe((Subscription)new ReactiveSubscription<M>(this, t){
                    private Map<ByteBuf, ByteBuf> firstValues;
                    private long iterPos;
                    private InetSocketAddress client;
                    private long currentIndex;
                    {
                        this.iterPos = 0L;
                    }

                    protected void onRequest(long n) {
                        this.currentIndex = n;
                        this.nextValues();
                    }

                    private Map<ByteBuf, ByteBuf> convert(Map<ScanObjectEntry, ScanObjectEntry> map) {
                        HashMap<ByteBuf, ByteBuf> result = new HashMap<ByteBuf, ByteBuf>(map.size());
                        for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : map.entrySet()) {
                            result.put(entry.getKey().getBuf(), entry.getValue().getBuf());
                        }
                        return result;
                    }

                    protected void nextValues() {
                        final 1 m = this;
                        RedissonMapReactiveIterator.this.map.scanIteratorReactive(this.client, this.iterPos).subscribe((Subscriber)new Subscriber<MapScanResult<ScanObjectEntry, ScanObjectEntry>>(){

                            public void onSubscribe(Subscription s) {
                                s.request(Long.MAX_VALUE);
                            }

                            private void free(Map<ByteBuf, ByteBuf> map) {
                                if (map == null) {
                                    return;
                                }
                                for (Map.Entry<ByteBuf, ByteBuf> entry : map.entrySet()) {
                                    entry.getKey().release();
                                    entry.getValue().release();
                                }
                            }

                            public void onNext(MapScanResult<ScanObjectEntry, ScanObjectEntry> res) {
                                client = res.getRedisClient();
                                if (iterPos == 0L && firstValues == null) {
                                    firstValues = this.convert(res.getMap());
                                } else if (this.convert(res.getMap()).equals(firstValues)) {
                                    this.free(firstValues);
                                    m.onComplete();
                                    currentIndex = 0L;
                                    return;
                                }
                                iterPos = res.getPos();
                                for (Map.Entry<ScanObjectEntry, ScanObjectEntry> entry : res.getMap().entrySet()) {
                                    Object val = RedissonMapReactiveIterator.this.getValue(entry);
                                    m.onNext(val);
                                    currentIndex--;
                                    if (currentIndex != 0L) continue;
                                    m.onComplete();
                                    return;
                                }
                            }

                            public void onError(Throwable error) {
                                m.onError(error);
                            }

                            public void onComplete() {
                                if (currentIndex == 0L) {
                                    return;
                                }
                                this.nextValues();
                            }
                        });
                    }
                });
            }
        };
    }

    M getValue(final Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey().getObj(), entry.getValue().getObj()){

            @Override
            public V setValue(V value) {
                Publisher publisher = RedissonMapReactiveIterator.this.map.put(((ScanObjectEntry)entry.getKey()).getObj(), value);
                return ((Stream)publisher).next().poll();
            }
        };
    }
}

