/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.spring.support.AbstractRedissonNamespaceDefinitionParser;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import reactor.core.support.Assert;

public class RedissonLiveObjectDefinitionParser
extends AbstractRedissonNamespaceDefinitionParser {
    public RedissonLiveObjectDefinitionParser(RedissonNamespaceParserSupport helper) {
        super(helper, "live-object-service-ref");
    }

    @Override
    protected void parseNested(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinition bd) {
        Class<?> apiClass;
        try {
            apiClass = Class.forName(this.helper.getAttribute(element, "class"));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("The class [" + this.helper.getAttribute(element, "class") + "] specified in \"api-class\" attribute has not found. Please check the class path.", ex);
        }
        Assert.state((this.helper.hasAttribute(element, "object-id") || this.helper.hasAttribute(element, "object-id-ref") ? 1 : 0) != 0, (String)"One of \"object-id\" or \"object-id-ref\" attribute is required in the \"live-object\" element.");
        builder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(this.helper.getAttribute(element, "live-object-service-ref")));
        builder.addPropertyValue("targetMethod", (Object)"get");
        ManagedList args = new ManagedList();
        args.add(apiClass);
        if (this.helper.hasAttribute(element, "object-id")) {
            args.add((Object)this.helper.getAttribute(element, "object-id"));
        }
        if (this.helper.hasAttribute(element, "object-id-ref")) {
            args.add((Object)new RuntimeBeanReference(this.helper.getAttribute(element, "object-id-ref")));
        }
        builder.addPropertyValue("arguments", (Object)args);
    }

    protected Class<?> getBeanClass(Element element) {
        return MethodInvokingFactoryBean.class;
    }
}

