/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SLF4JLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4FLogFactory
extends LogFactory {
    Map loggerMap;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    private static final String LOG_INTERFACE = "org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();
    private String logClassName;

    public SLF4FLogFactory() {
        this.loggerMap = new HashMap();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String string) throws LogConfigurationException {
        Log log = (Log)this.loggerMap.get(string);
        if (log == null) {
            Logger logger = LoggerFactory.getLogger((String)string);
            log = new SLF4JLog(logger);
            this.loggerMap.put(string, log);
        }
        return log;
    }

    public void release() {
        throw new UnsupportedOperationException("SLF4J bound commons-logging does not need to implement release().");
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }
}

