/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springdoc.api.OpenApiResourceNotFoundException;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocProviders;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.customizers.GlobalOperationCustomizer;
import org.springdoc.core.filters.GlobalOpenApiMethodFilter;
import org.springdoc.webflux.api.OpenApiActuatorResource;
import org.springdoc.webflux.api.OpenApiResource;
import org.springdoc.webflux.api.OpenApiWebfluxResource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class MultipleOpenApiResource
implements InitializingBean,
ApplicationContextAware {
    private final List<GroupedOpenApi> groupedOpenApis;
    private final ObjectFactory<OpenAPIService> defaultOpenAPIBuilder;
    private final AbstractRequestService requestBuilder;
    private final GenericResponseService responseBuilder;
    private final OperationService operationParser;
    private final SpringDocConfigProperties springDocConfigProperties;
    private Map<String, OpenApiResource> groupedOpenApiResources;
    private final SpringDocProviders springDocProviders;
    protected ApplicationContext applicationContext;

    protected MultipleOpenApiResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIService> defaultOpenAPIBuilder, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
        this.groupedOpenApis = groupedOpenApis;
        this.defaultOpenAPIBuilder = defaultOpenAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.springDocConfigProperties = springDocConfigProperties;
        this.springDocProviders = springDocProviders;
    }

    public void afterPropertiesSet() {
        Map globalOpenApiCustomizerMap = this.applicationContext.getBeansOfType(GlobalOpenApiCustomizer.class);
        Map globalOperationCustomizerMap = this.applicationContext.getBeansOfType(GlobalOperationCustomizer.class);
        Map globalOpenApiMethodFilterMap = this.applicationContext.getBeansOfType(GlobalOpenApiMethodFilter.class);
        this.groupedOpenApis.forEach(groupedOpenApi -> groupedOpenApi.addAllOpenApiCustomizer(globalOpenApiCustomizerMap.values()).addAllOperationCustomizer(globalOperationCustomizerMap.values()).addAllOpenApiMethodFilter(globalOpenApiMethodFilterMap.values()));
        this.groupedOpenApiResources = this.groupedOpenApis.stream().collect(Collectors.toMap(GroupedOpenApi::getGroup, item -> {
            SpringDocConfigProperties.GroupConfig groupConfig = new SpringDocConfigProperties.GroupConfig(item.getGroup(), item.getPathsToMatch(), item.getPackagesToScan(), item.getPackagesToExclude(), item.getPathsToExclude(), item.getProducesToMatch(), item.getConsumesToMatch(), item.getHeadersToMatch(), item.getDisplayName());
            this.springDocConfigProperties.addGroupConfig(groupConfig);
            return this.buildWebFluxOpenApiResource((GroupedOpenApi)item);
        }));
    }

    private OpenApiResource buildWebFluxOpenApiResource(GroupedOpenApi item) {
        if (!this.springDocConfigProperties.isUseManagementPort() && !"x-actuator".equals(item.getGroup())) {
            return new OpenApiWebfluxResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, Optional.of(item.getOperationCustomizers()), Optional.of(item.getOpenApiCustomisers()), Optional.of(item.getOpenApiMethodFilters()), this.springDocConfigProperties, this.springDocProviders);
        }
        return new OpenApiActuatorResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, Optional.of(item.getOperationCustomizers()), Optional.of(item.getOpenApiCustomisers()), Optional.of(item.getOpenApiMethodFilters()), this.springDocConfigProperties, this.springDocProviders);
    }

    protected OpenApiResource getOpenApiResourceOrThrow(String group) {
        OpenApiResource openApiResource = this.groupedOpenApiResources.get(group);
        if (openApiResource == null) {
            throw new OpenApiResourceNotFoundException("No OpenAPI resource found for group: " + group);
        }
        return openApiResource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

