/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;

public class RabbitGatewaySupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private RabbitOperations rabbitOperations;

    public final void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.rabbitOperations = this.createRabbitTemplate(connectionFactory);
    }

    protected RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory) {
        return new RabbitTemplate(connectionFactory);
    }

    @Nullable
    public final ConnectionFactory getConnectionFactory() {
        return this.rabbitOperations != null ? this.rabbitOperations.getConnectionFactory() : null;
    }

    public final void setRabbitOperations(RabbitOperations rabbitOperations) {
        this.rabbitOperations = rabbitOperations;
    }

    public final RabbitOperations getRabbitOperations() {
        return this.rabbitOperations;
    }

    public final void afterPropertiesSet() throws IllegalArgumentException, BeanInitializationException {
        if (this.rabbitOperations == null) {
            throw new IllegalArgumentException("'connectionFactory' or 'rabbitTemplate' is required");
        }
        try {
            this.initGateway();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Initialization of Rabbit gateway failed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected void initGateway() throws Exception {
    }
}

