/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.Nullable;

public class PersistentEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private final PersistentEntity<T, ? extends PersistentProperty<?>> persistentEntity;

    public PersistentEntityInformation(PersistentEntity<T, ?> entity) {
        super(entity.getType());
        this.persistentEntity = entity;
    }

    @Override
    @Nullable
    public ID getId(T entity) {
        return (ID)this.persistentEntity.getIdentifierAccessor(entity).getIdentifier();
    }

    @Override
    public Class<ID> getIdType() {
        return this.persistentEntity.getRequiredIdProperty().getType();
    }
}

