/*
 * Copyright 2018-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.rest.core;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;

import org.springframework.core.convert.converter.Converter;

/**
 * {@link Converter} to convert a {@link String} to a {@link LdapName}.
 *
 * @author Mark Paluch
 * @since 3.0.8
 */
public enum StringToLdapNameConverter implements Converter<String, Name> {

	INSTANCE;

	/*
	 * (non-Javadoc)
	 * @see org.springframework.core.convert.converter.Converter#convert(java.lang.Object)
	 */
	@Override
	public LdapName convert(String source) {

		try {
			return new LdapName(source);
		} catch (InvalidNameException e) {
			throw new IllegalArgumentException(String.format("Cannot create LdapName for '%s'!", source), e);
		}
	}
}
