/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EntityModel<T>
extends RepresentationModel<EntityModel<T>> {
    private final T content;

    protected EntityModel() {
        this.content = null;
    }

    public EntityModel(T content, Link ... links) {
        this(content, Arrays.asList(links));
    }

    public EntityModel(@Nullable T content, Iterable<Link> links) {
        Assert.notNull(content, (String)"Content must not be null!");
        Assert.isTrue((!(content instanceof Collection) ? 1 : 0) != 0, (String)"Content must not be a collection! Use Resources instead!");
        this.content = content;
        this.add(links);
    }

    @JsonUnwrapped
    @Nullable
    public T getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        return String.format("Resource { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        EntityModel that = (EntityModel)obj;
        boolean contentEqual = this.content == null ? that.content == null : this.content.equals(that.content);
        return contentEqual && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.content == null ? 0 : 17 * this.content.hashCode();
    }
}

