/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import lombok.Generated;
import org.springframework.util.Assert;
import org.springframework.web.util.UriUtils;

final class EncodingUtils {
    private static final String ENCODING = "UTF-8";

    public static String encodePath(Object source) {
        Assert.notNull((Object)source, (String)"Path value must not be null!");
        try {
            return UriUtils.encodePath((String)source.toString(), (String)ENCODING);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encodeParameter(Object source) {
        Assert.notNull((Object)source, (String)"Request parameter value must not be null!");
        try {
            return UriUtils.encodeQueryParam((String)source.toString(), (String)ENCODING);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encodeFragment(Object source) {
        Assert.notNull((Object)source, (String)"Fragment value must not be null!");
        try {
            return UriUtils.encodeFragment((String)source.toString(), (String)ENCODING);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Generated
    private EncodingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

