/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.core.AnnotationAttribute;
import org.springframework.hateoas.server.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.server.core.CachingMappingDiscoverer;
import org.springframework.hateoas.server.core.DummyInvocationUtils;
import org.springframework.hateoas.server.core.EncodingUtils;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.hateoas.server.core.SpringAffordanceBuilder;
import org.springframework.hateoas.server.core.UriTemplateFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class WebHandler {
    private static final MappingDiscoverer DISCOVERER = CachingMappingDiscoverer.of(new AnnotationMappingDiscoverer(RequestMapping.class));
    private static final Map<AffordanceKey, List<Affordance>> AFFORDANCES_CACHE = new ConcurrentReferenceHashMap();

    public static <T extends LinkBuilder> PreparedWebHandler<T> linkTo(Object invocationValue, LinkBuilderCreator<T> creator) {
        return WebHandler.linkTo(invocationValue, creator, null);
    }

    public static <T extends LinkBuilder> T linkTo(Object invocationValue, LinkBuilderCreator<T> creator, @Nullable BiFunction<UriComponentsBuilder, MethodInvocation, UriComponentsBuilder> additionalUriHandler, Function<String, UriComponentsBuilder> finisher) {
        return WebHandler.linkTo(invocationValue, creator, additionalUriHandler).conclude(finisher);
    }

    private static <T extends LinkBuilder> PreparedWebHandler<T> linkTo(Object invocationValue, LinkBuilderCreator<T> creator, @Nullable BiFunction<UriComponentsBuilder, MethodInvocation, UriComponentsBuilder> additionalUriHandler) {
        Assert.isInstanceOf(LastInvocationAware.class, (Object)invocationValue);
        LastInvocationAware invocations = DummyInvocationUtils.getLastInvocationAware(invocationValue);
        if (invocations == null) {
            throw new IllegalStateException(String.format("Could not obtain previous invocation from %s!", invocationValue));
        }
        MethodInvocation invocation = invocations.getLastInvocation();
        String mapping = DISCOVERER.getMapping(invocation.getTargetType(), invocation.getMethod());
        return finisher -> {
            UriComponentsBuilder builder = (UriComponentsBuilder)finisher.apply(mapping);
            UriTemplate template = UriTemplateFactory.templateFor(mapping == null ? "/" : mapping);
            HashMap<Object, Object> values = new HashMap<Object, Object>();
            List variableNames = template.getVariableNames();
            Iterator names = variableNames.iterator();
            Iterator<Object> classMappingParameters = invocations.getObjectParameters();
            while (classMappingParameters.hasNext()) {
                values.put(names.next(), EncodingUtils.encodePath(classMappingParameters.next()));
            }
            HandlerMethodParameters parameters = HandlerMethodParameters.of(invocation.getMethod());
            Object[] arguments = invocation.getArguments();
            for (HandlerMethodParameter handlerMethodParameter : parameters.getParameterAnnotatedWith(PathVariable.class, arguments)) {
                values.put(handlerMethodParameter.getVariableName(), EncodingUtils.encodePath(handlerMethodParameter.getValueAsString(arguments)));
            }
            ArrayList<String> optionalEmptyParameters = new ArrayList<String>();
            for (HandlerMethodParameter parameter : parameters.getParameterAnnotatedWith(RequestParam.class, arguments)) {
                WebHandler.bindRequestParameters(builder, parameter, arguments);
                if (!UriComponents.UriTemplateVariables.SKIP_VALUE.equals(parameter.getVerifiedValue(arguments))) continue;
                values.put(parameter.getVariableName(), UriComponents.UriTemplateVariables.SKIP_VALUE);
                if (parameter.isRequired()) continue;
                optionalEmptyParameters.add(parameter.getVariableName());
            }
            for (String variable : variableNames) {
                if (values.containsKey(variable)) continue;
                values.put(variable, UriComponents.UriTemplateVariables.SKIP_VALUE);
            }
            UriComponents uriComponents = additionalUriHandler == null ? builder.buildAndExpand(values) : ((UriComponentsBuilder)additionalUriHandler.apply(builder, invocation)).buildAndExpand(values);
            TemplateVariables variables = TemplateVariables.NONE;
            for (String parameter : optionalEmptyParameters) {
                boolean previousRequestParameter = uriComponents.getQueryParams().isEmpty() && variables.equals(TemplateVariables.NONE);
                TemplateVariable variable = new TemplateVariable(parameter, previousRequestParameter ? TemplateVariable.VariableType.REQUEST_PARAM : TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED);
                variables = variables.concat(variable);
            }
            List affordances = AFFORDANCES_CACHE.computeIfAbsent(AffordanceKey.of(invocation.getTargetType(), invocation.getMethod(), uriComponents), key -> SpringAffordanceBuilder.create(((AffordanceKey)key).type, ((AffordanceKey)key).method, ((AffordanceKey)key).href.toUriString(), DISCOVERER));
            return creator.createBuilder(uriComponents, variables, affordances);
        };
    }

    private static void bindRequestParameters(UriComponentsBuilder builder, HandlerMethodParameter parameter, Object[] arguments) {
        Object value = parameter.getVerifiedValue(arguments);
        if (value == null) {
            return;
        }
        String key = parameter.getVariableName();
        if (value instanceof MultiValueMap) {
            MultiValueMap requestParams = (MultiValueMap)value;
            for (Map.Entry multiValueEntry : requestParams.entrySet()) {
                for (String singleEntryValue : (List)multiValueEntry.getValue()) {
                    builder.queryParam((String)multiValueEntry.getKey(), new Object[]{EncodingUtils.encodeParameter(singleEntryValue)});
                }
            }
        } else if (value instanceof Map) {
            Map requestParams = (Map)value;
            for (Map.Entry requestParamEntry : requestParams.entrySet()) {
                builder.queryParam((String)requestParamEntry.getKey(), new Object[]{EncodingUtils.encodeParameter(requestParamEntry.getValue())});
            }
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                if (key == null) continue;
                builder.queryParam(key, new Object[]{EncodingUtils.encodeParameter(element)});
            }
        } else if (UriComponents.UriTemplateVariables.SKIP_VALUE.equals(value)) {
            if (parameter.isRequired() && key != null) {
                builder.queryParam(key, new Object[]{String.format("{%s}", key)});
            }
        } else if (key != null) {
            builder.queryParam(key, new Object[]{EncodingUtils.encodeParameter(parameter.getValueAsString(arguments))});
        }
    }

    private static class PathVariableParameter
    extends HandlerMethodParameter {
        public PathVariableParameter(MethodParameter parameter) {
            super(parameter, new AnnotationAttribute(PathVariable.class));
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    private static class RequestParamParameter
    extends HandlerMethodParameter {
        private final MethodParameter parameter;

        public RequestParamParameter(MethodParameter parameter) {
            super(parameter, new AnnotationAttribute(RequestParam.class));
            this.parameter = parameter;
        }

        @Override
        public boolean isRequired() {
            RequestParam annotation = (RequestParam)this.parameter.getParameterAnnotation(RequestParam.class);
            if (this.parameter.isOptional()) {
                return false;
            }
            return annotation != null && annotation.required() && annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        @Override
        @Nullable
        public Object getVerifiedValue(Object[] values) {
            Object value = ObjectUtils.unwrapOptional((Object)values[this.parameter.getParameterIndex()]);
            if (value != null) {
                return value;
            }
            RequestParam annotation = (RequestParam)this.parameter.getParameterAnnotation(RequestParam.class);
            if (annotation == null || !annotation.required() || this.parameter.isOptional()) {
                return UriComponents.UriTemplateVariables.SKIP_VALUE;
            }
            return annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? UriComponents.UriTemplateVariables.SKIP_VALUE : null;
        }
    }

    private static abstract class HandlerMethodParameter {
        private static final ConversionService CONVERSION_SERVICE = new DefaultFormattingConversionService();
        private static final TypeDescriptor STRING_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private static final Map<Class<? extends Annotation>, Function<MethodParameter, ? extends HandlerMethodParameter>> FACTORY = new HashMap<Class<? extends Annotation>, Function<MethodParameter, ? extends HandlerMethodParameter>>();
        private static final String NO_PARAMETER_NAME = "Could not determine name of parameter %s! Make sure you compile with parameter information or explicitly define a parameter name in %s.";
        private final MethodParameter parameter;
        private final AnnotationAttribute attribute;
        private final TypeDescriptor typeDescriptor;
        private String variableName;

        private HandlerMethodParameter(MethodParameter parameter, AnnotationAttribute attribute) {
            this.parameter = parameter;
            this.attribute = attribute;
            int nestingIndex = Optional.class.isAssignableFrom(parameter.getParameterType()) ? 1 : 0;
            this.typeDescriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)nestingIndex);
        }

        public static HandlerMethodParameter of(MethodParameter parameter, Class<? extends Annotation> type) {
            Function<MethodParameter, ? extends HandlerMethodParameter> function = FACTORY.get(type);
            if (function == null) {
                throw new IllegalArgumentException(String.format("Unsupported annotation type %s!", type.getName()));
            }
            return function.apply(parameter);
        }

        Class<? extends Annotation> getAnnotationType() {
            return this.attribute.getAnnotationType();
        }

        public String getVariableName() {
            if (this.variableName == null) {
                this.variableName = this.determineVariableName();
            }
            return this.variableName;
        }

        public String getValueAsString(Object[] values) {
            Object value = values[this.parameter.getParameterIndex()];
            if (value == null) {
                throw new IllegalArgumentException("Cannot turn null value into required String!");
            }
            if (String.class.isInstance(value)) {
                return (String)value;
            }
            Object result = CONVERSION_SERVICE.convert(value = ObjectUtils.unwrapOptional((Object)value), this.typeDescriptor, STRING_DESCRIPTOR);
            if (result == null) {
                throw new IllegalArgumentException(String.format("Conversion of value %s resulted in null!", value));
            }
            return (String)result;
        }

        private String determineVariableName() {
            String parameterName;
            if (this.attribute == null) {
                this.variableName = this.parameter.getParameterName();
                return this.variableName;
            }
            Annotation annotation = this.parameter.getParameterAnnotation(this.attribute.getAnnotationType());
            String string = parameterName = annotation != null ? this.attribute.getValueFrom(annotation) : "";
            if (parameterName != null && StringUtils.hasText((String)parameterName)) {
                return parameterName;
            }
            parameterName = this.parameter.getParameterName();
            if (parameterName == null) {
                throw new IllegalStateException(String.format(NO_PARAMETER_NAME, this.parameter, this.attribute.getAnnotationType()));
            }
            return parameterName;
        }

        @Nullable
        public Object getVerifiedValue(Object[] values) {
            return values[this.parameter.getParameterIndex()];
        }

        public abstract boolean isRequired();

        static {
            FACTORY.put(RequestParam.class, RequestParamParameter::new);
            FACTORY.put(PathVariable.class, PathVariableParameter::new);
        }
    }

    private static class HandlerMethodParameters {
        private static final List<Class<? extends Annotation>> ANNOTATIONS = Arrays.asList(RequestParam.class, PathVariable.class);
        private static final Map<Method, HandlerMethodParameters> CACHE = new ConcurrentHashMap<Method, HandlerMethodParameters>();
        private final MultiValueMap<Class<? extends Annotation>, HandlerMethodParameter> byAnnotationCache = new LinkedMultiValueMap();

        private HandlerMethodParameters(MethodParameters parameters) {
            for (Class<? extends Annotation> annotation : ANNOTATIONS) {
                this.byAnnotationCache.putAll((Map)parameters.getParametersWith(annotation).stream().map(it -> HandlerMethodParameter.of(it, annotation)).collect(Collectors.groupingBy(HandlerMethodParameter::getAnnotationType, LinkedMultiValueMap::new, Collectors.toList())));
            }
        }

        public static HandlerMethodParameters of(Method method) {
            return CACHE.computeIfAbsent(method, it -> {
                MethodParameters parameters = MethodParameters.of(it);
                return new HandlerMethodParameters(parameters);
            });
        }

        public List<HandlerMethodParameter> getParameterAnnotatedWith(Class<? extends Annotation> annotation, Object[] arguments) {
            List parameters = (List)this.byAnnotationCache.get(annotation);
            if (parameters == null) {
                return Collections.emptyList();
            }
            ArrayList<HandlerMethodParameter> result = new ArrayList<HandlerMethodParameter>();
            for (HandlerMethodParameter parameter : parameters) {
                if (parameter.getVerifiedValue(arguments) == null) continue;
                result.add(parameter);
            }
            return result;
        }
    }

    private static final class AffordanceKey {
        private final Class<?> type;
        private final Method method;
        private final UriComponents href;

        @Generated
        private AffordanceKey(Class<?> type, Method method, UriComponents href) {
            this.type = type;
            this.method = method;
            this.href = href;
        }

        @Generated
        public static AffordanceKey of(Class<?> type, Method method, UriComponents href) {
            return new AffordanceKey(type, method, href);
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Generated
        public UriComponents getHref() {
            return this.href;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AffordanceKey)) {
                return false;
            }
            AffordanceKey other = (AffordanceKey)o;
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            UriComponents this$href = this.getHref();
            UriComponents other$href = other.getHref();
            return !(this$href == null ? other$href != null : !this$href.equals(other$href));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            UriComponents $href = this.getHref();
            result = result * 59 + ($href == null ? 43 : $href.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebHandler.AffordanceKey(type=" + this.getType() + ", method=" + this.getMethod() + ", href=" + this.getHref() + ")";
        }
    }

    public static interface PreparedWebHandler<T extends LinkBuilder> {
        public T conclude(Function<String, UriComponentsBuilder> var1);
    }

    public static interface LinkBuilderCreator<T extends LinkBuilder> {
        public T createBuilder(UriComponents var1, TemplateVariables var2, List<Affordance> var3);
    }
}

