/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.springframework.integration.aop.PublisherMetadataSource;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class MethodNameMappingPublisherMetadataSource
implements PublisherMetadataSource {
    private final Map<String, String> payloadExpressionMap;
    private volatile Map<String, Map<String, String>> headerExpressionMap = Collections.emptyMap();
    private volatile Map<String, String> channelMap = Collections.emptyMap();

    public MethodNameMappingPublisherMetadataSource(Map<String, String> payloadExpressionMap) {
        Assert.notEmpty(payloadExpressionMap, (String)"payloadExpressionMap must not be empty");
        this.payloadExpressionMap = payloadExpressionMap;
    }

    public void setHeaderExpressionMap(Map<String, Map<String, String>> headerExpressionMap) {
        this.headerExpressionMap = headerExpressionMap;
    }

    public void setChannelMap(Map<String, String> channelMap) {
        this.channelMap = channelMap;
    }

    @Override
    public String getPayloadExpression(Method method) {
        for (Map.Entry<String, String> entry : this.payloadExpressionMap.entrySet()) {
            if (!PatternMatchUtils.simpleMatch((String)entry.getKey(), (String)method.getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<String, String> getHeaderExpressions(Method method) {
        for (Map.Entry<String, Map<String, String>> entry : this.headerExpressionMap.entrySet()) {
            if (!PatternMatchUtils.simpleMatch((String)entry.getKey(), (String)method.getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String getChannelName(Method method) {
        for (Map.Entry<String, String> entry : this.channelMap.entrySet()) {
            if (!PatternMatchUtils.simpleMatch((String)entry.getKey(), (String)method.getName())) continue;
            return entry.getValue();
        }
        return null;
    }
}

