/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.StringUtils;

public class ServiceActivatorAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<ServiceActivator> {
    public ServiceActivatorAnnotationPostProcessor(ConfigurableListableBeanFactory beanFactory) {
        super(beanFactory);
        this.messageHandlerAttributes.addAll(Arrays.asList("outputChannel", "requiresReply", "adviceChain"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        String requiresReply;
        AbstractReplyProducingMessageHandler serviceActivator;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            Object target = this.resolveTargetBeanFromMethodWithBeanAnnotation(method);
            serviceActivator = this.extractTypeIfPossible(target, AbstractReplyProducingMessageHandler.class);
            if (serviceActivator != null) {
                this.checkMessageHandlerAttributes(this.resolveTargetBeanName(method), annotations);
                return (MessageHandler)target;
            }
            if (target instanceof MessageHandler) {
                return new ReplyProducingMessageHandlerWrapper((MessageHandler)target);
            }
            serviceActivator = new ServiceActivatingHandler(target);
        } else {
            serviceActivator = new ServiceActivatingHandler(bean, method);
        }
        if (StringUtils.hasText((String)(requiresReply = MessagingAnnotationUtils.resolveAttribute(annotations, "requiresReply", String.class)))) {
            serviceActivator.setRequiresReply(Boolean.parseBoolean(this.beanFactory.resolveEmbeddedValue(requiresReply)));
        }
        this.setOutputChannelIfPresent(annotations, serviceActivator);
        return serviceActivator;
    }

    private final class ReplyProducingMessageHandlerWrapper
    extends AbstractReplyProducingMessageHandler
    implements Lifecycle {
        private final MessageHandler target;

        private ReplyProducingMessageHandlerWrapper(MessageHandler target) {
            this.target = target;
        }

        @Override
        protected Object handleRequestMessage(Message<?> requestMessage) {
            this.target.handleMessage(requestMessage);
            return null;
        }

        public void start() {
            if (this.target instanceof Lifecycle) {
                ((Lifecycle)this.target).start();
            }
        }

        public void stop() {
            if (this.target instanceof Lifecycle) {
                ((Lifecycle)this.target).stop();
            }
        }

        public boolean isRunning() {
            return !(this.target instanceof Lifecycle) || ((Lifecycle)this.target).isRunning();
        }
    }
}

