/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractChannelAdapterParser
extends AbstractBeanDefinitionParser {
    protected final String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!element.hasAttribute("channel")) {
            id = id + ".adapter";
        } else if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)parserContext.isNested());
        }
        return id;
    }

    protected final AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String role;
        String phase;
        String channelName = element.getAttribute("channel");
        if (!StringUtils.hasText((String)channelName)) {
            channelName = this.createDirectChannel(element, parserContext);
        }
        AbstractBeanDefinition beanDefinition = this.doParse(element, parserContext, channelName);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        String autoStartup = element.getAttribute("auto-startup");
        if (StringUtils.hasText((String)autoStartup)) {
            propertyValues.add("autoStartup", (Object)new TypedStringValue(autoStartup));
        }
        if (StringUtils.hasText((String)(phase = element.getAttribute("phase")))) {
            propertyValues.add("phase", (Object)new TypedStringValue(phase));
        }
        if (StringUtils.hasText((String)(role = element.getAttribute("role")))) {
            if (!StringUtils.hasText((String)element.getAttribute("id"))) {
                parserContext.getReaderContext().error("When using 'role', 'id' is required", (Object)element);
            }
            IntegrationNamespaceUtils.putLifecycleInRole(role, element.getAttribute("id"), parserContext);
        }
        return beanDefinition;
    }

    private String createDirectChannel(Element element, ParserContext parserContext) {
        if (parserContext.isNested()) {
            return null;
        }
        return IntegrationNamespaceUtils.createDirectChannel(element, parserContext);
    }

    protected abstract AbstractBeanDefinition doParse(Element var1, ParserContext var2, String var3);
}

