/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.handler.ReplyRequiredException;
import org.springframework.integration.handler.advice.HandleMessageAdvice;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class AbstractReplyProducingMessageHandler
extends AbstractMessageProducingHandler
implements BeanClassLoaderAware {
    private volatile RequestHandler advisedRequestHandler;
    private volatile List<Advice> adviceChain;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private volatile boolean requiresReply = false;

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    protected boolean getRequiresReply() {
        return this.requiresReply;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        Assert.notNull(adviceChain, (String)"adviceChain cannot be null");
        this.adviceChain = adviceChain;
    }

    protected boolean hasAdviceChain() {
        return this.adviceChain != null && this.adviceChain.size() > 0;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    protected final void onInit() throws Exception {
        super.onInit();
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)new AdvisedRequestHandler());
            boolean advised = false;
            for (Advice advice : this.adviceChain) {
                if (advice instanceof HandleMessageAdvice) continue;
                proxyFactory.addAdvice(advice);
                advised = true;
            }
            if (advised) {
                this.advisedRequestHandler = (RequestHandler)proxyFactory.getProxy(this.beanClassLoader);
            }
        }
        this.doInit();
    }

    protected void doInit() {
    }

    @Override
    protected final void handleMessageInternal(Message<?> message) {
        Object result = this.advisedRequestHandler == null ? this.handleRequestMessage(message) : this.doInvokeAdvisedRequestHandler(message);
        if (result != null) {
            this.sendOutputs(result, message);
        } else {
            if (this.requiresReply && !this.isAsync()) {
                throw new ReplyRequiredException(message, "No reply produced by handler '" + this.getComponentName() + "', and its 'requiresReply' property is set to true.");
            }
            if (!this.isAsync() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("handler '" + this + "' produced no reply for request Message: " + message));
            }
        }
    }

    protected Object doInvokeAdvisedRequestHandler(Message<?> message) {
        return this.advisedRequestHandler.handleRequestMessage(message);
    }

    protected abstract Object handleRequestMessage(Message<?> var1);

    private class AdvisedRequestHandler
    implements RequestHandler {
        private AdvisedRequestHandler() {
        }

        @Override
        public Object handleRequestMessage(Message<?> requestMessage) {
            return AbstractReplyProducingMessageHandler.this.handleRequestMessage(requestMessage);
        }

        @Override
        public String toString() {
            return AbstractReplyProducingMessageHandler.this.toString();
        }

        @Override
        public AbstractReplyProducingMessageHandler getAdvisedHandler() {
            return AbstractReplyProducingMessageHandler.this;
        }
    }

    public static interface RequestHandler {
        public Object handleRequestMessage(Message<?> var1);

        public String toString();

        public AbstractReplyProducingMessageHandler getAdvisedHandler();
    }
}

