/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.MethodInvokingMessageProcessor;
import org.springframework.messaging.Message;

public class ServiceActivatingHandler
extends AbstractReplyProducingMessageHandler
implements Lifecycle {
    private final MessageProcessor<?> processor;

    public ServiceActivatingHandler(Object object) {
        this(new MethodInvokingMessageProcessor(object, ServiceActivator.class));
    }

    public ServiceActivatingHandler(Object object, Method method) {
        this(new MethodInvokingMessageProcessor(object, method));
    }

    public ServiceActivatingHandler(Object object, String methodName) {
        this(new MethodInvokingMessageProcessor(object, methodName));
    }

    public <T> ServiceActivatingHandler(MessageProcessor<T> processor) {
        this.processor = processor;
    }

    @Override
    public String getComponentType() {
        return "service-activator";
    }

    @Override
    protected void doInit() {
        if (this.processor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.processor).setConversionService(this.getConversionService());
        }
        if (this.processor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.processor).setBeanFactory(this.getBeanFactory());
        }
    }

    public void start() {
        if (this.processor instanceof Lifecycle) {
            ((Lifecycle)this.processor).start();
        }
    }

    public void stop() {
        if (this.processor instanceof Lifecycle) {
            ((Lifecycle)this.processor).stop();
        }
    }

    public boolean isRunning() {
        return !(this.processor instanceof Lifecycle) || ((Lifecycle)this.processor).isRunning();
    }

    @Override
    protected Object handleRequestMessage(Message<?> message) {
        return this.processor.processMessage(message);
    }

    @Override
    public String toString() {
        return "ServiceActivator for [" + this.processor + "]" + (this.getComponentName() == null ? "" : " (" + this.getComponentName() + ")");
    }
}

