/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.advice.AbstractRequestHandlerAdvice;
import org.springframework.integration.message.AdviceMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class ExpressionEvaluatingRequestHandlerAdvice
extends AbstractRequestHandlerAdvice {
    private volatile Expression onSuccessExpression;
    private volatile MessageChannel successChannel;
    private volatile String successChannelName;
    private volatile Expression onFailureExpression;
    private volatile MessageChannel failureChannel;
    private volatile String failureChannelName;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private volatile boolean trapException = false;
    private volatile boolean returnFailureExpressionResult = false;
    private volatile boolean propagateOnSuccessEvaluationFailures;
    private volatile EvaluationContext evaluationContext;

    @Deprecated
    public void setOnSuccessExpression(String onSuccessExpression) {
        this.setOnSuccessExpressionString(onSuccessExpression);
    }

    public void setOnSuccessExpressionString(String onSuccessExpression) {
        Assert.notNull((Object)onSuccessExpression, (String)"'onSuccessExpression' must not be null");
        this.onSuccessExpression = EXPRESSION_PARSER.parseExpression(onSuccessExpression);
    }

    public void setExpressionOnSuccess(Expression onSuccessExpression) {
        this.onSuccessExpression = onSuccessExpression;
    }

    @Deprecated
    public void setOnFailureExpression(String onFailureExpression) {
        this.setOnFailureExpressionString(onFailureExpression);
    }

    public void setOnFailureExpressionString(String onFailureExpression) {
        Assert.notNull((Object)onFailureExpression, (String)"'onFailureExpression' must not be null");
        this.onFailureExpression = EXPRESSION_PARSER.parseExpression(onFailureExpression);
    }

    public void setExpressionOnFailure(Expression onFailureExpression) {
        this.onFailureExpression = onFailureExpression;
    }

    public void setSuccessChannel(MessageChannel successChannel) {
        this.successChannel = successChannel;
    }

    public void setSuccessChannelName(String successChannelName) {
        this.successChannelName = successChannelName;
    }

    public void setFailureChannel(MessageChannel failureChannel) {
        this.failureChannel = failureChannel;
    }

    public void setFailureChannelName(String failureChannelName) {
        this.failureChannelName = failureChannelName;
    }

    public void setTrapException(boolean trapException) {
        this.trapException = trapException;
    }

    public void setReturnFailureExpressionResult(boolean returnFailureExpressionResult) {
        this.returnFailureExpressionResult = returnFailureExpressionResult;
    }

    public void setPropagateEvaluationFailures(boolean propagateOnSuccessEvaluationFailures) {
        this.propagateOnSuccessEvaluationFailures = propagateOnSuccessEvaluationFailures;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (this.getBeanFactory() != null) {
            this.messagingTemplate.setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected Object doInvoke(AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target, Message<?> message) throws Exception {
        try {
            Object result = callback.execute();
            if (this.onSuccessExpression != null) {
                this.evaluateSuccessExpression(message);
            }
            return result;
        }
        catch (Exception e) {
            Exception actualException = this.unwrapExceptionIfNecessary(e);
            if (this.onFailureExpression != null) {
                Object evalResult = this.evaluateFailureExpression(message, actualException);
                if (this.returnFailureExpressionResult) {
                    return evalResult;
                }
            }
            if (!this.trapException) {
                throw actualException;
            }
            return null;
        }
    }

    private void evaluateSuccessExpression(Message<?> message) throws Exception {
        Object evalResult;
        boolean evaluationFailed = false;
        try {
            evalResult = this.onSuccessExpression.getValue(this.prepareEvaluationContextToUse(null), message);
        }
        catch (Exception e) {
            evalResult = e;
            evaluationFailed = true;
        }
        if (this.successChannel == null && this.successChannelName != null && this.getChannelResolver() != null) {
            this.successChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.successChannelName);
        }
        if (evalResult != null && this.successChannel != null) {
            AdviceMessage<Object> resultMessage = new AdviceMessage<Object>(evalResult, message);
            this.messagingTemplate.send(this.successChannel, (Message)resultMessage);
        }
        if (evaluationFailed && this.propagateOnSuccessEvaluationFailures) {
            throw (Exception)evalResult;
        }
    }

    private Object evaluateFailureExpression(Message<?> message, Exception exception) throws Exception {
        Object evalResult;
        try {
            evalResult = this.onFailureExpression.getValue(this.prepareEvaluationContextToUse(exception), message);
        }
        catch (Exception e) {
            evalResult = e;
            this.logger.error((Object)("Failure expression evaluation failed for " + message + ": " + e.getMessage()));
        }
        if (this.failureChannel == null && this.failureChannelName != null && this.getChannelResolver() != null) {
            this.failureChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.failureChannelName);
        }
        if (evalResult != null && this.failureChannel != null) {
            MessageHandlingExpressionEvaluatingAdviceException messagingException = new MessageHandlingExpressionEvaluatingAdviceException(message, "Handler Failed", this.unwrapThrowableIfNecessary(exception), evalResult);
            ErrorMessage resultMessage = new ErrorMessage((Throwable)((Object)messagingException));
            this.messagingTemplate.send(this.failureChannel, (Message)resultMessage);
        }
        return evalResult;
    }

    protected StandardEvaluationContext createEvaluationContext() {
        return ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
    }

    private EvaluationContext prepareEvaluationContextToUse(Exception exception) {
        StandardEvaluationContext evaluationContextToUse;
        if (exception != null) {
            evaluationContextToUse = this.createEvaluationContext();
            evaluationContextToUse.setVariable("exception", (Object)exception);
        } else {
            if (this.evaluationContext == null) {
                this.evaluationContext = this.createEvaluationContext();
            }
            evaluationContextToUse = this.evaluationContext;
        }
        return evaluationContextToUse;
    }

    public static class MessageHandlingExpressionEvaluatingAdviceException
    extends MessagingException {
        private static final long serialVersionUID = 1L;
        private final Object evaluationResult;

        public MessageHandlingExpressionEvaluatingAdviceException(Message<?> message, String description, Throwable cause, Object evaluationResult) {
            super(message, description, cause);
            this.evaluationResult = evaluationResult;
        }

        public Object getEvaluationResult() {
            return this.evaluationResult;
        }
    }
}

