/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.util.Function;
import org.springframework.integration.util.FunctionIterator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractMessageSplitter
extends AbstractReplyProducingMessageHandler {
    private boolean applySequence = true;

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    @Override
    protected final Object handleRequestMessage(Message<?> message) {
        Iterator<Object> iterator;
        int sequenceSize;
        Object[] items;
        Object result = this.splitMessage(message);
        if (result == null) {
            return null;
        }
        if (result instanceof Collection) {
            items = (Object[])result;
            sequenceSize = items.size();
            iterator = items.iterator();
        } else if (result.getClass().isArray()) {
            items = (Object[])result;
            sequenceSize = items.length;
            iterator = Arrays.asList(items).iterator();
        } else if (result instanceof Iterable) {
            sequenceSize = 0;
            iterator = ((Iterable)result).iterator();
        } else if (result instanceof Iterator) {
            sequenceSize = 0;
            iterator = (Iterator<Object>)result;
        } else {
            sequenceSize = 1;
            iterator = Collections.singleton(result).iterator();
        }
        if (!iterator.hasNext()) {
            return null;
        }
        Object messageHeaders = message.getHeaders();
        if (this.willAddHeaders(message)) {
            messageHeaders = new HashMap(messageHeaders);
            this.addHeaders(message, (Map<String, Object>)messageHeaders);
        }
        MessageHeaders headers = messageHeaders;
        UUID correlationId = message.getHeaders().getId();
        AtomicInteger sequenceNumber = new AtomicInteger(1);
        return new FunctionIterator(iterator, new Function<Object, AbstractIntegrationMessageBuilder<?>>((Map)headers, correlationId, sequenceNumber, sequenceSize){
            final /* synthetic */ Map val$headers;
            final /* synthetic */ Object val$correlationId;
            final /* synthetic */ AtomicInteger val$sequenceNumber;
            final /* synthetic */ int val$sequenceSize;
            {
                this.val$headers = map;
                this.val$correlationId = object;
                this.val$sequenceNumber = atomicInteger;
                this.val$sequenceSize = n;
            }

            @Override
            public AbstractIntegrationMessageBuilder<?> apply(Object object) {
                return AbstractMessageSplitter.this.createBuilder(object, this.val$headers, this.val$correlationId, this.val$sequenceNumber.getAndIncrement(), this.val$sequenceSize);
            }
        });
    }

    private AbstractIntegrationMessageBuilder<?> createBuilder(Object item, Map<String, Object> headers, Object correlationId, int sequenceNumber, int sequenceSize) {
        AbstractIntegrationMessageBuilder<Object> builder = item instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)item) : (item instanceof AbstractIntegrationMessageBuilder ? (AbstractIntegrationMessageBuilder<Object>)item : this.getMessageBuilderFactory().withPayload(item));
        builder.copyHeadersIfAbsent(headers);
        if (this.applySequence) {
            builder.pushSequenceDetails(correlationId, sequenceNumber, sequenceSize);
        }
        return builder;
    }

    protected boolean willAddHeaders(Message<?> message) {
        return false;
    }

    protected void addHeaders(Message<?> message, Map<String, Object> headers) {
    }

    @Override
    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    @Override
    protected void produceOutput(Object result, Message<?> requestMessage) {
        Iterator iterator = (Iterator)result;
        while (iterator.hasNext()) {
            super.produceOutput(iterator.next(), requestMessage);
        }
    }

    @Override
    public String getComponentType() {
        return "splitter";
    }

    protected abstract Object splitMessage(Message<?> var1);
}

