/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractKeyValueMessageStore
extends AbstractMessageGroupStore
implements MessageStore {
    protected static final String MESSAGE_KEY_PREFIX = "MESSAGE_";
    protected static final String MESSAGE_GROUP_KEY_PREFIX = "MESSAGE_GROUP_";
    protected static final String CREATED_DATE = "CREATED_DATE";

    @Override
    public Message<?> getMessage(UUID id) {
        Message<?> message = this.getRawMessage(id);
        if (message != null) {
            return this.normalizeMessage(message);
        }
        return null;
    }

    @Override
    public <T> Message<T> addMessage(Message<T> message) {
        this.doAddMessage(message);
        return this.getMessage(message.getHeaders().getId());
    }

    protected void doAddMessage(Message<?> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        UUID messageId = message.getHeaders().getId();
        this.doStore(MESSAGE_KEY_PREFIX + messageId, message);
    }

    @Override
    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Object message = this.doRemove(MESSAGE_KEY_PREFIX + id);
        if (message != null) {
            Assert.isInstanceOf(Message.class, (Object)message);
        }
        if (message != null) {
            return this.normalizeMessage((Message)message);
        }
        return null;
    }

    @Override
    @ManagedAttribute
    public long getMessageCount() {
        Collection<?> messageIds = this.doListKeys("MESSAGE_*");
        return messageIds != null ? (long)messageIds.size() : 0L;
    }

    @Override
    public MessageGroup getMessageGroup(Object groupId) {
        MessageGroupMetadata metadata = this.getGroupMetadata(groupId);
        if (metadata != null) {
            MessageGroup messageGroup = this.getMessageGroupFactory().create(this, groupId, metadata.getTimestamp(), metadata.isComplete());
            messageGroup.setLastModified(metadata.getLastModified());
            messageGroup.setLastReleasedMessageSequenceNumber(metadata.getLastReleasedMessageSequenceNumber());
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    @Override
    public MessageGroupMetadata getGroupMetadata(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Object mgm = this.doRetrieve(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            return (MessageGroupMetadata)mgm;
        }
        return null;
    }

    @Override
    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'messages' must not be null");
        MessageGroupMetadata metadata = this.getGroupMetadata(groupId);
        SimpleMessageGroup group = null;
        if (metadata == null) {
            group = new SimpleMessageGroup(groupId);
        }
        for (Message<?> message : messages) {
            Message<?> enrichedMessage = this.enrichMessage(message);
            this.doAddMessage(enrichedMessage);
            if (metadata != null) {
                metadata.add(enrichedMessage.getHeaders().getId());
                continue;
            }
            group.add(enrichedMessage);
        }
        if (group != null) {
            metadata = new MessageGroupMetadata(group);
            metadata.setLastModified(group.getTimestamp());
        } else {
            metadata.setLastModified(System.currentTimeMillis());
        }
        this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, metadata);
    }

    @Override
    @Deprecated
    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        UUID id = messageToRemove.getHeaders().getId();
        this.removeMessage(id);
        MessageGroupMetadata metadata = this.getGroupMetadata(groupId);
        if (metadata != null) {
            metadata.remove(id);
            metadata.setLastModified(System.currentTimeMillis());
            this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, metadata);
        }
        return this.getMessageGroup(groupId);
    }

    @Override
    public void removeMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'messages' must not be null");
        Object mgm = this.doRetrieve(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            MessageGroupMetadata messageGroupMetadata = (MessageGroupMetadata)mgm;
            for (Message<?> messageToRemove : messages) {
                UUID messageId = messageToRemove.getHeaders().getId();
                messageGroupMetadata.remove(messageId);
                this.doRemove(MESSAGE_KEY_PREFIX + messageId);
            }
            messageGroupMetadata.setLastModified(System.currentTimeMillis());
            this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, messageGroupMetadata);
        }
    }

    @Override
    public void completeGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        MessageGroupMetadata metadata = this.getGroupMetadata(groupId);
        if (metadata != null) {
            metadata.complete();
            metadata.setLastModified(System.currentTimeMillis());
            this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, metadata);
        }
    }

    @Override
    public void removeMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Object mgm = this.doRemove(MESSAGE_GROUP_KEY_PREFIX + groupId);
        if (mgm != null) {
            Assert.isInstanceOf(MessageGroupMetadata.class, (Object)mgm);
            MessageGroupMetadata messageGroupMetadata = (MessageGroupMetadata)mgm;
            Iterator<UUID> messageIds = messageGroupMetadata.messageIdIterator();
            while (messageIds.hasNext()) {
                this.removeMessage(messageIds.next());
            }
        }
    }

    @Override
    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        MessageGroupMetadata metadata = this.getGroupMetadata(groupId);
        if (metadata == null) {
            SimpleMessageGroup messageGroup = new SimpleMessageGroup(groupId);
            metadata = new MessageGroupMetadata(messageGroup);
        }
        metadata.setLastReleasedMessageSequenceNumber(sequenceNumber);
        metadata.setLastModified(System.currentTimeMillis());
        this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, metadata);
    }

    @Override
    public Message<?> pollMessageFromGroup(Object groupId) {
        UUID firstId;
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupId);
        if (groupMetadata != null && (firstId = groupMetadata.firstId()) != null) {
            groupMetadata.remove(firstId);
            groupMetadata.setLastModified(System.currentTimeMillis());
            this.doStore(MESSAGE_GROUP_KEY_PREFIX + groupId, groupMetadata);
            return this.removeMessage(firstId);
        }
        return null;
    }

    @Override
    public Message<?> getOneMessageFromGroup(Object groupId) {
        UUID messageId;
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupId);
        if (groupMetadata != null && (messageId = groupMetadata.firstId()) != null) {
            return this.getMessage(messageId);
        }
        return null;
    }

    @Override
    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupId);
        ArrayList messages = new ArrayList();
        if (groupMetadata != null) {
            Iterator<UUID> messageIds = groupMetadata.messageIdIterator();
            while (messageIds.hasNext()) {
                messages.add(this.getMessage(messageIds.next()));
            }
        }
        return messages;
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        Iterator<String> idIterator = this.normalizeKeys(this.doListKeys("MESSAGE_GROUP_*")).iterator();
        return new MessageGroupIterator(idIterator);
    }

    private Collection<String> normalizeKeys(Collection<String> keys) {
        HashSet<String> normalizedKeys = new HashSet<String>();
        for (String key : keys) {
            String strKey = key;
            if (strKey.startsWith(MESSAGE_GROUP_KEY_PREFIX)) {
                strKey = strKey.replace(MESSAGE_GROUP_KEY_PREFIX, "");
            } else if (strKey.startsWith(MESSAGE_KEY_PREFIX)) {
                strKey = strKey.replace(MESSAGE_KEY_PREFIX, "");
            }
            normalizedKeys.add(strKey);
        }
        return normalizedKeys;
    }

    @Override
    public int messageGroupSize(Object groupId) {
        MessageGroupMetadata mgm = this.getGroupMetadata(groupId);
        if (mgm != null) {
            return mgm.size();
        }
        return 0;
    }

    protected abstract Object doRetrieve(Object var1);

    protected abstract void doStore(Object var1, Object var2);

    protected abstract Object doRemove(Object var1);

    protected abstract Collection<?> doListKeys(String var1);

    private Message<?> normalizeMessage(Message<?> message) {
        Message<?> normalizedMessage = this.getMessageBuilderFactory().fromMessage(message).removeHeader(CREATED_DATE).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)normalizedMessage.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().getId());
        innerMap.put("timestamp", message.getHeaders().getTimestamp());
        return normalizedMessage;
    }

    private Message<?> enrichMessage(Message<?> message) {
        Message<?> enrichedMessage = this.getMessageBuilderFactory().fromMessage(message).setHeader(CREATED_DATE, System.currentTimeMillis()).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)enrichedMessage.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().getId());
        innerMap.put("timestamp", message.getHeaders().getTimestamp());
        return enrichedMessage;
    }

    private Message<?> getRawMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Object message = this.doRetrieve(MESSAGE_KEY_PREFIX + id);
        return (Message)message;
    }

    private final class MessageGroupIterator
    implements Iterator<MessageGroup> {
        private final Iterator<?> idIterator;

        private MessageGroupIterator(Iterator<?> idIterator) {
            this.idIterator = idIterator;
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public MessageGroup next() {
            Object messageGroupId = this.idIterator.next();
            return AbstractKeyValueMessageStore.this.getMessageGroup(messageGroupId);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

