/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management.graph;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.integration.context.ExpressionCapable;
import org.springframework.integration.support.context.NamedComponent;

public abstract class IntegrationNode {
    private final int nodeId;
    private final String name;
    private final Stats stats;
    private final String componentType;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    protected IntegrationNode(int nodeId, String name, Object nodeObject, Stats stats) {
        Expression expression;
        this.nodeId = nodeId;
        this.name = name;
        this.componentType = nodeObject instanceof NamedComponent ? ((NamedComponent)nodeObject).getComponentType() : nodeObject.getClass().getSimpleName();
        this.stats = stats;
        if (nodeObject instanceof ExpressionCapable && (expression = ((ExpressionCapable)nodeObject).getExpression()) != null) {
            this.properties.put("expression", expression.getExpressionString());
        }
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getName() {
        return this.name;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public Stats getStats() {
        return this.stats.isAvailable() ? this.stats : null;
    }

    public Map<String, Object> getProperties() {
        return this.properties.size() == 0 ? null : this.properties;
    }

    public static class Stats {
        protected boolean isAvailable() {
            return false;
        }
    }
}

