/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.util.Assert;

public class DefaultTestContext
extends AttributeAccessorSupport
implements TestContext {
    private static final long serialVersionUID = -5827157174866681233L;
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    private final MergedContextConfiguration mergedContextConfiguration;
    private final Class<?> testClass;
    private Object testInstance;
    private Method testMethod;
    private Throwable testException;

    public DefaultTestContext(Class<?> testClass, MergedContextConfiguration mergedContextConfiguration, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        Assert.notNull(testClass, (String)"testClass must not be null");
        Assert.notNull((Object)mergedContextConfiguration, (String)"MergedContextConfiguration must not be null");
        Assert.notNull((Object)cacheAwareContextLoaderDelegate, (String)"CacheAwareContextLoaderDelegate must not be null");
        this.testClass = testClass;
        this.mergedContextConfiguration = mergedContextConfiguration;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        ApplicationContext context = this.cacheAwareContextLoaderDelegate.loadContext(this.mergedContextConfiguration);
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)context;
            Assert.state((boolean)cac.isActive(), (String)("The ApplicationContext loaded for [" + this.mergedContextConfiguration + "] is not active. Ensure that the context has not been closed programmatically."));
        }
        return context;
    }

    @Override
    public void markApplicationContextDirty(DirtiesContext.HierarchyMode hierarchyMode) {
        this.cacheAwareContextLoaderDelegate.closeContext(this.mergedContextConfiguration, hierarchyMode);
    }

    @Override
    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public final Object getTestInstance() {
        return this.testInstance;
    }

    @Override
    public final Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public final Throwable getTestException() {
        return this.testException;
    }

    @Override
    public void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).append("mergedContextConfiguration", (Object)this.mergedContextConfiguration).toString();
    }
}

