/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.intf.TioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpUuid;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.common.session.id.impl.UUIDSessionIdGenerator;
import org.tio.http.server.HttpServerAioHandler;
import org.tio.http.server.HttpServerAioListener;
import org.tio.http.server.util.Threads;
import org.tio.server.AioServer;
import org.tio.server.ServerGroupContext;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class HttpServerStarter {
    private static Logger log = LoggerFactory.getLogger(HttpServerStarter.class);
    private HttpConfig httpConfig = null;
    private HttpServerAioHandler httpServerAioHandler = null;
    private HttpServerAioListener httpServerAioListener = null;
    private ServerGroupContext serverGroupContext = null;
    private AioServer aioServer = null;
    private HttpRequestHandler httpRequestHandler;

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this(httpConfig, requestHandler, null, null);
    }

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        if (tioExecutor == null) {
            tioExecutor = Threads.tioExecutor;
        }
        if (groupExecutor == null) {
            groupExecutor = Threads.groupExecutor;
        }
        this.init(httpConfig, requestHandler, tioExecutor, groupExecutor);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public HttpServerAioHandler getHttpServerAioHandler() {
        return this.httpServerAioHandler;
    }

    public HttpServerAioListener getHttpServerAioListener() {
        return this.httpServerAioListener;
    }

    public ServerGroupContext getServerGroupContext() {
        return this.serverGroupContext;
    }

    private void init(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.httpConfig = httpConfig;
        this.httpRequestHandler = requestHandler;
        httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.httpServerAioHandler = new HttpServerAioHandler(httpConfig, requestHandler);
        this.httpServerAioListener = new HttpServerAioListener();
        this.serverGroupContext = new ServerGroupContext("Tio Http Server", (ServerAioHandler)this.httpServerAioHandler, (ServerAioListener)this.httpServerAioListener, tioExecutor, groupExecutor);
        this.serverGroupContext.setHeartbeatTimeout(20000L);
        this.serverGroupContext.setShortConnection(true);
        this.serverGroupContext.setAttribute("TIO_HTTP_SERVER_CONFIG", (Object)httpConfig);
        this.aioServer = new AioServer(this.serverGroupContext);
        HttpUuid imTioUuid = new HttpUuid();
        this.serverGroupContext.setTioUuid((TioUuid)imTioUuid);
    }

    public void setHttpRequestHandler(HttpRequestHandler requestHandler) {
        this.httpRequestHandler = requestHandler;
    }

    public void start() throws IOException {
        if (this.httpConfig.getSessionStore() == null) {
            CaffeineCache caffeineCache = CaffeineCache.register((String)this.httpConfig.getSessionCacheName(), null, (Long)this.httpConfig.getSessionTimeout());
            this.httpConfig.setSessionStore((ICache)caffeineCache);
        }
        if (this.httpConfig.getSessionIdGenerator() == null) {
            this.httpConfig.setSessionIdGenerator((ISessionIdGenerator)UUIDSessionIdGenerator.instance);
        }
        this.aioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort().intValue());
    }

    public void stop() throws IOException {
        this.aioServer.stop();
    }
}

