/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.handler;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.RequestLine;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.HttpSession;
import org.tio.http.server.intf.CurrUseridGetter;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.intf.ThrowableHandler;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.session.HttpSessionListener;
import org.tio.http.server.session.SessionCookieDecorator;
import org.tio.http.server.stat.StatPathFilter;
import org.tio.http.server.stat.ip.path.IpAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStat;
import org.tio.http.server.stat.ip.path.IpPathAccessStatListener;
import org.tio.http.server.stat.ip.path.IpPathAccessStats;
import org.tio.http.server.stat.token.TokenAccessStat;
import org.tio.http.server.stat.token.TokenPathAccessStat;
import org.tio.http.server.stat.token.TokenPathAccessStatListener;
import org.tio.http.server.stat.token.TokenPathAccessStats;
import org.tio.http.server.util.Resps;
import org.tio.http.server.view.freemarker.FreemarkerConfig;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.caffeine.CaffeineCache;

public class DefaultHttpRequestHandler
implements HttpRequestHandler {
    private static Logger log = LoggerFactory.getLogger(DefaultHttpRequestHandler.class);
    private static final String STATIC_RES_CONTENT_CACHENAME = "TIO_HTTP_STATIC_RES_CONTENT";
    protected HttpConfig httpConfig;
    protected Routes routes = null;
    private HttpServerInterceptor httpServerInterceptor;
    private HttpSessionListener httpSessionListener;
    private ThrowableHandler throwableHandler;
    private SessionCookieDecorator sessionCookieDecorator;
    private IpPathAccessStats ipPathAccessStats;
    private TokenPathAccessStats tokenPathAccessStats;
    private CaffeineCache staticResCache;
    private String contextPath;
    private int contextPathLength = 0;
    private String suffix;
    private int suffixLength = 0;
    private FreemarkerConfig freemarkerConfig;

    public static void main(String[] args) {
    }

    public DefaultHttpRequestHandler(HttpConfig httpConfig, Routes routes) {
        if (httpConfig == null) {
            throw new RuntimeException("httpConfig can not be null");
        }
        this.contextPath = httpConfig.getContextPath();
        this.suffix = httpConfig.getSuffix();
        if (StringUtils.isNotBlank((CharSequence)this.contextPath)) {
            this.contextPathLength = this.contextPath.length();
        }
        if (StringUtils.isNotBlank((CharSequence)this.suffix)) {
            this.suffixLength = this.suffix.length();
        }
        this.httpConfig = httpConfig;
        if (httpConfig.getMaxLiveTimeOfStaticRes() > 0) {
            this.staticResCache = CaffeineCache.register((String)STATIC_RES_CONTENT_CACHENAME, (Long)Long.valueOf(httpConfig.getMaxLiveTimeOfStaticRes()), null);
        }
        this.routes = routes;
    }

    private HttpSession createSession(HttpRequest request) {
        String sessionId = this.httpConfig.getSessionIdGenerator().sessionId(this.httpConfig, request);
        HttpSession httpSession = new HttpSession(sessionId);
        if (this.httpSessionListener != null) {
            this.httpSessionListener.doAfterCreated(request, httpSession, this.httpConfig);
        }
        return httpSession;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpServerInterceptor getHttpServerInterceptor() {
        return this.httpServerInterceptor;
    }

    public static Cookie getSessionCookie(HttpRequest request, HttpConfig httpConfig) {
        Cookie sessionCookie = request.getCookie(httpConfig.getSessionCookieName());
        return sessionCookie;
    }

    public CaffeineCache getStaticResCache() {
        return this.staticResCache;
    }

    private boolean checkDomain(HttpRequest request) {
        Object[] allowDomains = this.httpConfig.getAllowDomains();
        if (allowDomains == null || allowDomains.length == 0) {
            return true;
        }
        String host = request.getHost();
        return ArrayUtil.contains((Object[])allowDomains, (Object)host);
    }

    /*
     * Exception decompiling
     */
    public HttpResponse handler(HttpRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[TRYBLOCK], 56[CATCHBLOCK]], but top level block is 27[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean statIpPath(HttpRequest request, HttpResponse response, String path, long iv) {
        if (response.isSkipIpStat() || request.isClosed()) {
            return true;
        }
        if (this.ipPathAccessStats != null) {
            String ip = request.getClientIp();
            List<Long> list = this.ipPathAccessStats.durationList;
            Cookie cookie = DefaultHttpRequestHandler.getSessionCookie(request, this.httpConfig);
            StatPathFilter statPathFilter = this.ipPathAccessStats.getStatPathFilter();
            for (Long duration : list) {
                boolean isContinue;
                IpPathAccessStatListener ipPathAccessStatListener;
                IpAccessStat ipAccessStat = this.ipPathAccessStats.get(duration, ip);
                ipAccessStat.count.incrementAndGet();
                ipAccessStat.timeCost.addAndGet(iv);
                ipAccessStat.setLastAccessTime(SystemTimer.currentTimeMillis());
                if (cookie == null) {
                    ipAccessStat.noSessionCount.incrementAndGet();
                } else {
                    ipAccessStat.sessionIds.add((Object)cookie.getValue());
                }
                if (!statPathFilter.filter(path, request, response)) continue;
                IpPathAccessStat ipPathAccessStat = ipAccessStat.get(path);
                ipPathAccessStat.count.incrementAndGet();
                ipPathAccessStat.timeCost.addAndGet(iv);
                ipPathAccessStat.setLastAccessTime(SystemTimer.currentTimeMillis());
                if (cookie == null) {
                    ipPathAccessStat.noSessionCount.incrementAndGet();
                } else {
                    ipAccessStat.sessionIds.add((Object)cookie.getValue());
                }
                if ((ipPathAccessStatListener = this.ipPathAccessStats.getListener(duration)) == null || (isContinue = ipPathAccessStatListener.onChanged(request, ip, path, ipAccessStat, ipPathAccessStat))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean statTokenPath(HttpRequest request, HttpResponse response, String path, long iv) {
        String token;
        if (response.isSkipTokenStat() || request.isClosed()) {
            return true;
        }
        if (this.tokenPathAccessStats != null && StringUtils.isNotBlank((CharSequence)(token = this.tokenPathAccessStats.getTokenGetter().getToken(request)))) {
            List<Long> list = this.tokenPathAccessStats.durationList;
            CurrUseridGetter currUseridGetter = this.tokenPathAccessStats.getCurrUseridGetter();
            String uid = null;
            if (currUseridGetter != null) {
                uid = currUseridGetter.getUserid(request);
            }
            StatPathFilter statPathFilter = this.tokenPathAccessStats.getStatPathFilter();
            for (Long duration : list) {
                boolean isContinue;
                TokenAccessStat tokenAccessStat = this.tokenPathAccessStats.get(duration, token, request.getClientIp(), uid);
                tokenAccessStat.count.incrementAndGet();
                tokenAccessStat.timeCost.addAndGet(iv);
                tokenAccessStat.setLastAccessTime(SystemTimer.currentTimeMillis());
                if (!statPathFilter.filter(path, request, response)) continue;
                TokenPathAccessStat tokenPathAccessStat = tokenAccessStat.get(path);
                tokenPathAccessStat.count.incrementAndGet();
                tokenPathAccessStat.timeCost.addAndGet(iv);
                tokenPathAccessStat.setLastAccessTime(SystemTimer.currentTimeMillis());
                TokenPathAccessStatListener tokenPathAccessStatListener = this.tokenPathAccessStats.getListener(duration);
                if (tokenPathAccessStatListener == null || (isContinue = tokenPathAccessStatListener.onChanged(request, token, path, tokenAccessStat, tokenPathAccessStat))) continue;
                return false;
            }
        }
        return true;
    }

    private void logError(HttpRequest request, RequestLine requestLine, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append("remote  :").append(request.getRemote());
        sb.append("\r\n").append("request :").append(requestLine.getLine());
        log.error(sb.toString(), e);
    }

    private void processCookieAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse httpResponse) throws ExecutionException {
        if (!this.httpConfig.isUseSession()) {
            return;
        }
        HttpSession httpSession = request.getHttpSession();
        Cookie cookie = DefaultHttpRequestHandler.getSessionCookie(request, this.httpConfig);
        String sessionId = null;
        if (cookie == null) {
            this.createSessionCookie(request, httpSession, httpResponse);
        } else {
            sessionId = cookie.getValue();
            HttpSession httpSession1 = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession1 == null) {
                this.createSessionCookie(request, httpSession, httpResponse);
            }
        }
    }

    private void createSessionCookie(HttpRequest request, HttpSession httpSession, HttpResponse httpResponse) {
        String[] dms;
        String session_cookie_key = "tio_http_session_cookie";
        ChannelContext channelContext = request.getChannelContext();
        Object test = channelContext.getAttribute(session_cookie_key);
        if (test != null) {
            return;
        }
        String sessionId = httpSession.getId();
        String domain = request.getDomain();
        boolean isip = Validator.isIpv4((String)domain);
        if (!isip && (dms = StringUtils.split((String)domain, (String)".")).length > 2) {
            domain = "." + dms[dms.length - 2] + "." + dms[dms.length - 1];
        }
        String name = this.httpConfig.getSessionCookieName();
        long maxAge = 315360000L;
        Cookie sessionCookie = new Cookie(domain, name, sessionId, Long.valueOf(maxAge));
        if (this.sessionCookieDecorator != null) {
            this.sessionCookieDecorator.decorate(sessionCookie, request, request.getDomain());
        }
        httpResponse.addCookie(sessionCookie);
        this.httpConfig.getSessionStore().put(sessionId, (Serializable)httpSession);
        channelContext.setAttribute(session_cookie_key, (Object)sessionCookie);
    }

    private void processCookieBeforeHandler(HttpRequest request, RequestLine requestLine) throws ExecutionException {
        if (!this.httpConfig.isUseSession()) {
            return;
        }
        Cookie cookie = DefaultHttpRequestHandler.getSessionCookie(request, this.httpConfig);
        HttpSession httpSession = null;
        if (cookie == null) {
            httpSession = this.createSession(request);
        } else {
            String sessionId = cookie.getValue();
            httpSession = (HttpSession)this.httpConfig.getSessionStore().get(sessionId);
            if (httpSession == null) {
                log.info("{} session\u3010{}\u3011\u8d85\u65f6", (Object)request.getChannelContext(), (Object)sessionId);
                httpSession = this.createSession(request);
            }
        }
        request.setHttpSession(httpSession);
    }

    public HttpResponse resp404(HttpRequest request, RequestLine requestLine) {
        return Resps.resp404(request, requestLine, this.httpConfig);
    }

    public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) {
        if (this.throwableHandler != null) {
            return this.throwableHandler.handler(request, requestLine, throwable);
        }
        return Resps.resp500(request, requestLine, this.httpConfig, throwable);
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setHttpServerInterceptor(HttpServerInterceptor httpServerInterceptor) {
        this.httpServerInterceptor = httpServerInterceptor;
    }

    public void setStaticResCache(CaffeineCache staticResCache) {
        this.staticResCache = staticResCache;
    }

    public void clearStaticResCache(HttpRequest request) {
        if (this.staticResCache != null) {
            this.staticResCache.clear();
        }
    }

    public HttpSessionListener getHttpSessionListener() {
        return this.httpSessionListener;
    }

    public void setHttpSessionListener(HttpSessionListener httpSessionListener) {
        this.httpSessionListener = httpSessionListener;
    }

    public SessionCookieDecorator getSessionCookieDecorator() {
        return this.sessionCookieDecorator;
    }

    public void setSessionCookieDecorator(SessionCookieDecorator sessionCookieDecorator) {
        this.sessionCookieDecorator = sessionCookieDecorator;
    }

    public IpPathAccessStats getIpPathAccessStats() {
        return this.ipPathAccessStats;
    }

    public void setIpPathAccessStats(IpPathAccessStats ipPathAccessStats) {
        this.ipPathAccessStats = ipPathAccessStats;
    }

    public FreemarkerConfig getFreemarkerConfig() {
        return this.freemarkerConfig;
    }

    public void setFreemarkerConfig(FreemarkerConfig freemarkerConfig) {
        this.freemarkerConfig = freemarkerConfig;
    }

    public ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    public TokenPathAccessStats getTokenPathAccessStats() {
        return this.tokenPathAccessStats;
    }

    public void setTokenPathAccessStats(TokenPathAccessStats tokenPathAccessStats) {
        this.tokenPathAccessStats = tokenPathAccessStats;
    }
}

