/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.mvc;

import cn.hutool.core.util.ArrayUtil;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jodd.io.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.annotation.RequestPath;
import org.tio.http.server.mvc.DefaultControllerFactory;
import org.tio.http.server.mvc.PathUnitVo;
import org.tio.http.server.mvc.VariablePathVo;
import org.tio.http.server.mvc.intf.ControllerFactory;
import org.tio.utils.json.Json;

public class Routes {
    private static Logger log = LoggerFactory.getLogger(Routes.class);
    public Map<String, Object> pathBeanMap = new TreeMap<String, Object>();
    public static Map<Class<?>, Object> classBeanMap = new HashMap();
    public Map<String, Class<?>> pathClassMap = new TreeMap();
    public Map<Class<?>, String> classPathMap = new HashMap();
    public Map<String, Method> pathMethodMap = new TreeMap<String, Method>();
    public Map<Method, String[]> methodParamnameMap = new HashMap<Method, String[]>();
    public Map<Method, Object> methodBeanMap = new HashMap<Method, Object>();
    public Map<String, String> pathMethodstrMap = new TreeMap<String, String>();
    public Map<Integer, VariablePathVo[]> variablePathMap = new TreeMap<Integer, VariablePathVo[]>();
    public Map<String, String> variablePathMethodstrMap = new TreeMap<String, String>();
    StringBuilder errorStr = new StringBuilder();

    private static String formatBeanPath(String initPath) {
        return initPath;
    }

    private static String formatMethodPath(String initPath) {
        return initPath;
    }

    public static void main(String[] args) {
    }

    public Routes(String[] scanPackages) {
        this(scanPackages, DefaultControllerFactory.me);
    }

    public Routes(String[] scanPackages, final ControllerFactory controllerFactory) {
        if (scanPackages != null) {
            FastClasspathScanner fastClasspathScanner = new FastClasspathScanner(scanPackages);
            fastClasspathScanner.matchClassesWithAnnotation(RequestPath.class, new ClassAnnotationMatchProcessor(){

                public void processMatch(Class<?> classWithAnnotation) {
                    try {
                        Object bean = controllerFactory.getInstance(classWithAnnotation);
                        RequestPath mapping = classWithAnnotation.getAnnotation(RequestPath.class);
                        String beanPath = mapping.value();
                        beanPath = Routes.formatBeanPath(beanPath);
                        Object obj = Routes.this.pathBeanMap.get(beanPath);
                        if (obj != null) {
                            log.error("mapping[{}] already exists in class [{}]", (Object)beanPath, (Object)obj.getClass().getName());
                            Routes.this.errorStr.append("mapping[" + beanPath + "] already exists in class [" + obj.getClass().getName() + "]\r\n\r\n");
                        } else {
                            Routes.this.pathBeanMap.put(beanPath, bean);
                            classBeanMap.put(classWithAnnotation, bean);
                            Routes.this.pathClassMap.put(beanPath, classWithAnnotation);
                            Routes.this.classPathMap.put(classWithAnnotation, beanPath);
                        }
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            });
            fastClasspathScanner.matchClassesWithMethodAnnotation(RequestPath.class, new MethodAnnotationMatchProcessor(){

                public void processMatch(Class<?> matchingClass, Executable matchingMethodOrConstructor) {
                    RequestPath mapping = matchingMethodOrConstructor.getAnnotation(RequestPath.class);
                    String methodName = matchingMethodOrConstructor.getName();
                    String methodPath = mapping.value();
                    methodPath = Routes.formatMethodPath(methodPath);
                    String beanPath = Routes.this.classPathMap.get(matchingClass);
                    if (StringUtils.isBlank((CharSequence)beanPath)) {
                        log.error("\u65b9\u6cd5\u6709\u6ce8\u89e3\uff0c\u4f46\u7c7b\u6ca1\u6ce8\u89e3, method:{}, class:{}", (Object)methodName, matchingClass);
                        Routes.this.errorStr.append("\u65b9\u6cd5\u6709\u6ce8\u89e3\uff0c\u4f46\u7c7b\u6ca1\u6ce8\u89e3, method:" + methodName + ", class:" + matchingClass + "\r\n\r\n");
                        return;
                    }
                    Object bean = Routes.this.pathBeanMap.get(beanPath);
                    String completeMethodPath = methodPath;
                    if (beanPath != null) {
                        completeMethodPath = beanPath + methodPath;
                    }
                    Class<?>[] parameterTypes = matchingMethodOrConstructor.getParameterTypes();
                    try {
                        Method method = matchingClass.getMethod(methodName, parameterTypes);
                        BytecodeReadingParanamer paranamer = new BytecodeReadingParanamer();
                        String[] parameterNames = paranamer.lookupParameterNames((AccessibleObject)method, false);
                        Method checkMethod = Routes.this.pathMethodMap.get(completeMethodPath);
                        if (checkMethod != null) {
                            log.error("mapping[{}] already exists in method [{}]", (Object)completeMethodPath, (Object)(checkMethod.getDeclaringClass() + "#" + checkMethod.getName()));
                            Routes.this.errorStr.append("mapping[" + completeMethodPath + "] already exists in method [" + checkMethod.getDeclaringClass() + "#" + checkMethod.getName() + "]\r\n\r\n");
                            return;
                        }
                        Routes.this.pathMethodMap.put(completeMethodPath, method);
                        Routes.this.pathMethodstrMap.put(completeMethodPath, Routes.this.methodToStr(method, parameterNames));
                        Routes.this.methodParamnameMap.put(method, parameterNames);
                        Routes.this.methodBeanMap.put(method, bean);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            });
            fastClasspathScanner.scan();
            String pathClassMapStr = Json.toFormatedJson(this.pathClassMap);
            log.info("class  mapping\r\n{}", (Object)pathClassMapStr);
            String pathMethodstrMapStr = Json.toFormatedJson(this.pathMethodstrMap);
            log.info("method mapping\r\n{}", (Object)pathMethodstrMapStr);
            this.processVariablePath();
            String variablePathMethodstrMapStr = Json.toFormatedJson(this.variablePathMethodstrMap);
            log.info("variable path mapping\r\n{}", (Object)variablePathMethodstrMapStr);
            try {
                FileUtil.writeString((String)"/tio_mvc_path_class.json", (String)pathClassMapStr, (String)"utf-8");
                FileUtil.writeString((String)"/tio_mvc_path_method.json", (String)pathMethodstrMapStr, (String)"utf-8");
                FileUtil.writeString((String)"/tio_mvc_variablepath_method.json", (String)variablePathMethodstrMapStr, (String)"utf-8");
                if (this.errorStr.length() > 0) {
                    FileUtil.writeString((String)"/tio_error_mvc.txt", (String)this.errorStr.toString(), (String)"utf-8");
                }
            }
            catch (IOException e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    private void processVariablePath() {
        Set<Map.Entry<String, Method>> set = this.pathMethodMap.entrySet();
        for (Map.Entry<String, Method> entry : set) {
            String path = entry.getKey();
            Method method = entry.getValue();
            if (!StringUtils.contains((CharSequence)path, (CharSequence)"{") || !StringUtils.contains((CharSequence)path, (CharSequence)"}")) continue;
            String[] pathUnits = StringUtils.split((String)path, (String)"/");
            PathUnitVo[] pathUnitVos = new PathUnitVo[pathUnits.length];
            boolean isVarPath = false;
            for (int i = 0; i < pathUnits.length; ++i) {
                PathUnitVo pathUnitVo = new PathUnitVo();
                String pathUnit = pathUnits[i];
                if (StringUtils.contains((CharSequence)pathUnit, (CharSequence)"{") || StringUtils.contains((CharSequence)pathUnit, (CharSequence)"}")) {
                    if (StringUtils.startsWith((CharSequence)pathUnit, (CharSequence)"{") && StringUtils.endsWith((CharSequence)pathUnit, (CharSequence)"}")) {
                        String varName;
                        Object[] xx = this.methodParamnameMap.get(method);
                        if (ArrayUtil.contains((Object[])xx, (Object)(varName = StringUtils.substringBetween((String)pathUnit, (String)"{", (String)"}")))) {
                            isVarPath = true;
                            pathUnitVo.setVar(true);
                            pathUnitVo.setPath(varName);
                        } else {
                            log.error("path:{}, \u5bf9\u5e94\u7684\u65b9\u6cd5\u4e2d\u5e76\u6ca1\u6709\u5305\u542b\u53c2\u6570\u540d\u4e3a{}\u7684\u53c2\u6570", (Object)path, (Object)varName);
                            this.errorStr.append("path:{" + path + "}, \u5bf9\u5e94\u7684\u65b9\u6cd5\u4e2d\u5e76\u6ca1\u6709\u5305\u542b\u53c2\u6570\u540d\u4e3a" + varName + "\u7684\u53c2\u6570\r\n\r\n");
                        }
                    } else {
                        pathUnitVo.setVar(false);
                        pathUnitVo.setPath(pathUnit);
                    }
                } else {
                    pathUnitVo.setVar(false);
                    pathUnitVo.setPath(pathUnit);
                }
                pathUnitVos[i] = pathUnitVo;
            }
            if (!isVarPath) continue;
            VariablePathVo variablePathVo = new VariablePathVo(path, method, pathUnitVos);
            this.addVariablePathVo(pathUnits.length, variablePathVo);
        }
    }

    private VariablePathVo[] getVariablePathVos(Integer pathUnitCount, boolean forceCreate) {
        VariablePathVo[] ret = this.variablePathMap.get(pathUnitCount);
        if (forceCreate && ret == null) {
            ret = new VariablePathVo[]{};
            this.variablePathMap.put(pathUnitCount, ret);
        }
        return ret;
    }

    public static <T> T getController(Class<T> clazz) {
        return (T)classBeanMap.get(clazz);
    }

    private void addVariablePathVo(Integer pathUnitCount, VariablePathVo variablePathVo) {
        VariablePathVo[] existValue = this.variablePathMap.get(pathUnitCount);
        if (existValue == null) {
            existValue = new VariablePathVo[]{variablePathVo};
            this.variablePathMap.put(pathUnitCount, existValue);
        } else {
            VariablePathVo[] newExistValue = new VariablePathVo[existValue.length + 1];
            System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
            newExistValue[newExistValue.length - 1] = variablePathVo;
            this.variablePathMap.put(pathUnitCount, newExistValue);
        }
        this.variablePathMethodstrMap.put(variablePathVo.getPath(), this.methodToStr(variablePathVo.getMethod(), this.methodParamnameMap.get(variablePathVo.getMethod())));
    }

    private String methodToStr(Method method, String[] parameterNames) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + ArrayUtil.join((Object[])parameterNames, (CharSequence)",") + ")";
    }

    public Method getMethodByPath(String path, HttpRequest request) {
        Method method = this.pathMethodMap.get(path);
        if (method == null) {
            String[] pathUnitsOfRequest = StringUtils.split((String)path, (String)"/");
            VariablePathVo[] variablePathVos = this.variablePathMap.get(pathUnitsOfRequest.length);
            if (variablePathVos != null) {
                block0: for (VariablePathVo variablePathVo : variablePathVos) {
                    PathUnitVo[] pathUnitVos = variablePathVo.getPathUnits();
                    for (int i = 0; i < pathUnitVos.length; ++i) {
                        PathUnitVo pathUnitVo = pathUnitVos[i];
                        String pathUnitOfRequest = pathUnitsOfRequest[i];
                        if (pathUnitVo.isVar()) {
                            request.addParam(pathUnitVo.getPath(), (Object)pathUnitOfRequest);
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)pathUnitVo.getPath(), (CharSequence)pathUnitOfRequest)) continue block0;
                    }
                    method = variablePathVo.getMethod();
                    return method;
                }
            }
            return null;
        }
        return method;
    }
}

