/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.session;

import cn.hutool.core.util.ReUtil;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpRequest;
import org.tio.http.server.session.SessionCookieDecorator;

public class DomainMappingSessionCookieDecorator
implements SessionCookieDecorator {
    private static Logger log = LoggerFactory.getLogger(DomainMappingSessionCookieDecorator.class);
    private Map<String, String> domainMap = null;

    public DomainMappingSessionCookieDecorator(Map<String, String> domainMap) {
        this.domainMap = domainMap;
    }

    protected DomainMappingSessionCookieDecorator() {
    }

    public void addMapping(String key, String value) {
        this.domainMap.put(key, value);
    }

    public void removeMapping(String key) {
        this.domainMap.remove(key);
    }

    @Override
    public void decorate(Cookie sessionCookie, HttpRequest request, String domain) {
        Set<Map.Entry<String, String>> set = this.domainMap.entrySet();
        String initDomain = sessionCookie.getDomain();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)initDomain) && !ReUtil.isMatch((String)key, (String)initDomain)) continue;
            sessionCookie.setDomain(value);
        }
    }

    public static void main(String[] args) {
    }
}

