/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.stat.token;

import cn.hutool.core.date.BetweenFormater;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.tio.http.server.stat.token.TokenPathAccessStat;
import org.tio.utils.SystemTimer;
import org.tio.utils.lock.MapWithLock;

public class TokenAccessStat
implements Serializable {
    private static final long serialVersionUID = 5314797979230623121L;
    private MapWithLock<String, TokenPathAccessStat> tokenPathAccessStatMap = new MapWithLock(new HashMap());
    private Long durationType;
    private String ip;
    private String uid;
    private long duration;
    private String token;
    private long firstAccessTime = SystemTimer.currentTimeMillis();
    private long lastAccessTime = SystemTimer.currentTimeMillis();
    public final AtomicInteger count = new AtomicInteger();
    public final AtomicLong timeCost = new AtomicLong();

    public long getDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.firstAccessTime;
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TokenPathAccessStat get(String path) {
        return this.get(path, true);
    }

    public TokenPathAccessStat get(String path, boolean forceCreate) {
        if (path == null) {
            return null;
        }
        TokenPathAccessStat tokenPathAccessStat = (TokenPathAccessStat)this.tokenPathAccessStatMap.get((Object)path);
        if (tokenPathAccessStat == null && forceCreate) {
            tokenPathAccessStat = (TokenPathAccessStat)this.tokenPathAccessStatMap.putIfAbsent((Object)path, (Object)new TokenPathAccessStat(this.durationType, this.token, path, this.ip, this.uid));
        }
        return tokenPathAccessStat;
    }

    public TokenAccessStat(Long durationType, String token, String ip, String uid) {
        this.durationType = durationType;
        this.token = token;
        this.ip = ip;
        this.setUid(uid);
    }

    public MapWithLock<String, TokenPathAccessStat> getTokenPathAccessStatMap() {
        return this.tokenPathAccessStatMap;
    }

    public void setTokenPathAccessStatMap(MapWithLock<String, TokenPathAccessStat> tokenPathAccessStatMap) {
        this.tokenPathAccessStatMap = tokenPathAccessStatMap;
    }

    public String getFormatedDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.firstAccessTime;
        BetweenFormater betweenFormater = new BetweenFormater(this.duration, BetweenFormater.Level.MILLSECOND);
        return betweenFormater.format();
    }

    public double getPerSecond() {
        int count = this.count.get();
        long duration = this.getDuration();
        double perSecond = (double)count / (double)duration * 1000.0;
        return perSecond;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getFirstAccessTime() {
        return this.firstAccessTime;
    }

    public void setFirstAccessTime(long firstAccessTime) {
        this.firstAccessTime = firstAccessTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

