/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.util;

import cn.hutool.core.util.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;

public class HttpServerUtils {
    private static Logger log = LoggerFactory.getLogger(HttpServerUtils.class);

    public static void gzip(HttpRequest request, HttpResponse response) {
        if (response == null) {
            return;
        }
        if (response.isHasGzipped()) {
            return;
        }
        if (request.getIsSupportGzip().booleanValue()) {
            byte[] bs2;
            byte[] bs = response.getBody();
            if (bs != null && bs.length >= 300 && (bs2 = ZipUtil.gzip((byte[])bs)).length < bs.length) {
                response.setBody(bs2);
                response.setHasGzipped(true);
                response.addHeader(HttpConst.ResponseHeaderKey.Content_Encoding, "gzip");
            }
        } else {
            log.warn("{}, \u4e0d\u652f\u6301gzip, {}", (Object)request.getClientIp(), (Object)request.getHeader("user-agent"));
        }
    }

    public static void main(String[] args) {
    }
}

