/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import jodd.io.FileNameUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.MimeType;
import org.tio.http.common.RequestLine;
import org.tio.utils.json.Json;

public class Resps {
    private static Logger log = LoggerFactory.getLogger(Resps.class);

    public static HttpResponse css(HttpRequest request, String bodyString) {
        return Resps.css(request, bodyString, request.getHttpConfig().getCharset());
    }

    public static HttpResponse css(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, MimeType.TEXT_CSS_CSS.getType() + ";charset=" + charset);
        return ret;
    }

    public static HttpResponse bytes(HttpRequest request, byte[] bodyBytes, String extension) {
        String contentType = null;
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            MimeType mimeType = MimeType.fromExtension((String)extension);
            contentType = mimeType != null ? mimeType.getType() : "application/octet-stream";
        }
        return Resps.bytesWithContentType(request, bodyBytes, contentType);
    }

    public static HttpResponse file(HttpRequest request, File fileOnServer) throws IOException {
        Date lastModified = FileUtil.lastModifiedTime((File)fileOnServer);
        HttpResponse ret = Resps.try304(request, lastModified.getTime());
        if (ret != null) {
            return ret;
        }
        byte[] bodyBytes = FileUtil.readBytes((File)fileOnServer);
        String filename = fileOnServer.getName();
        String extension = FileNameUtil.getExtension((String)filename);
        ret = Resps.bytes(request, bodyBytes, extension);
        ret.setLastModified(lastModified.getTime() + "");
        return ret;
    }

    public static HttpResponse file(HttpRequest request, String path, HttpConfig httpConfig) throws IOException {
        File pageRoot = httpConfig.getPageRoot();
        if (pageRoot != null) {
            File file = new File(pageRoot + path);
            if (!file.exists()) {
                return Resps.resp404(request, request.getRequestLine(), httpConfig);
            }
            return Resps.file(request, file);
        }
        return Resps.resp404(request, request.getRequestLine(), httpConfig);
    }

    public static HttpResponse resp404(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig) {
        File pageRoot = httpConfig.getPageRoot();
        if (pageRoot != null) {
            String file404 = httpConfig.getPage404();
            File file = new File(pageRoot + file404);
            if (file.exists()) {
                HttpResponse ret = Resps.redirect(request, file404 + "?tio_initpath=" + requestLine.getPathAndQuery());
                return ret;
            }
        }
        HttpResponse ret = Resps.html(request, "404");
        ret.setStatus(HttpResponseStatus.C404);
        return ret;
    }

    public static HttpResponse resp500(HttpRequest request, RequestLine requestLine, HttpConfig httpConfig, Throwable throwable) {
        File pageRoot = httpConfig.getPageRoot();
        if (pageRoot != null) {
            String file500 = httpConfig.getPage500();
            File file = new File(pageRoot + file500);
            if (file.exists()) {
                HttpResponse ret = Resps.redirect(request, file500 + "?tio_initpath=" + requestLine.getPathAndQuery());
                return ret;
            }
        }
        HttpResponse ret = Resps.html(request, "500");
        ret.setStatus(HttpResponseStatus.C500);
        return ret;
    }

    public static HttpResponse bytesWithContentType(HttpRequest request, byte[] bodyBytes, String contentType) {
        HttpResponse ret = new HttpResponse(request);
        ret.setBody(bodyBytes);
        ret.addHeader(HttpConst.ResponseHeaderKey.Content_Type, contentType);
        return ret;
    }

    public static HttpResponse bytesWithHeaders(HttpRequest request, byte[] bodyBytes, Map<String, String> headers) {
        HttpResponse ret = new HttpResponse(request);
        ret.setBody(bodyBytes);
        ret.addHeaders(headers);
        return ret;
    }

    public static HttpResponse html(HttpRequest request, String bodyString) {
        HttpConfig httpConfig = request.getHttpConfig();
        return Resps.html(request, bodyString, httpConfig.getCharset());
    }

    public static HttpResponse html(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, MimeType.TEXT_HTML_HTML.getType() + ";charset=" + charset);
        return ret;
    }

    public static HttpResponse js(HttpRequest request, String bodyString) {
        return Resps.js(request, bodyString, request.getHttpConfig().getCharset());
    }

    public static HttpResponse js(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, MimeType.APPLICATION_JAVASCRIPT_JS.getType() + ";charset=" + charset);
        return ret;
    }

    public static HttpResponse json(HttpRequest request, Object body) {
        return Resps.json(request, body, request.getHttpConfig().getCharset());
    }

    public static HttpResponse json(HttpRequest request, Object body, String charset) {
        HttpResponse ret = null;
        ret = body == null ? Resps.string(request, "", charset, MimeType.TEXT_PLAIN_JSON.getType() + ";charset=" + charset) : (body.getClass() == String.class || ClassUtil.isBasicType(body.getClass()) ? Resps.string(request, body + "", charset, MimeType.TEXT_PLAIN_JSON.getType() + ";charset=" + charset) : Resps.string(request, Json.toJson((Object)body), charset, MimeType.TEXT_PLAIN_JSON.getType() + ";charset=" + charset));
        return ret;
    }

    public static void main(String[] args) {
    }

    public static HttpResponse redirect(HttpRequest request, String path) {
        HttpResponse ret = new HttpResponse(request);
        ret.setStatus(HttpResponseStatus.C302);
        ret.addHeader(HttpConst.ResponseHeaderKey.Location, path);
        return ret;
    }

    public static HttpResponse redirectForever(HttpRequest request, String path) {
        HttpResponse ret = new HttpResponse(request);
        ret.setStatus(HttpResponseStatus.C301);
        ret.addHeader(HttpConst.ResponseHeaderKey.Location, path);
        return ret;
    }

    public static HttpResponse string(HttpRequest request, String bodyString, String Content_Type) {
        return Resps.string(request, bodyString, request.getHttpConfig().getCharset(), Content_Type);
    }

    public static HttpResponse string(HttpRequest request, String bodyString, String charset, String Content_Type) {
        HttpResponse ret = new HttpResponse(request);
        if (bodyString != null) {
            try {
                ret.setBody(bodyString.getBytes(charset));
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        ret.addHeader(HttpConst.ResponseHeaderKey.Content_Type, Content_Type);
        return ret;
    }

    public static HttpResponse try304(HttpRequest request, long lastModifiedOnServer) {
        String If_Modified_Since = request.getHeader("if-modified-since");
        if (StringUtils.isNotBlank((CharSequence)If_Modified_Since)) {
            Long If_Modified_Since_Date = null;
            try {
                If_Modified_Since_Date = Long.parseLong(If_Modified_Since);
                if (lastModifiedOnServer <= If_Modified_Since_Date) {
                    HttpResponse ret = new HttpResponse(request);
                    ret.setStatus(HttpResponseStatus.C304);
                    return ret;
                }
            }
            catch (NumberFormatException e) {
                log.warn("{}, {}\u4e0d\u662f\u6574\u6570\uff0c\u6d4f\u89c8\u5668\u4fe1\u606f:{}", new Object[]{request.getRemote(), If_Modified_Since, request.getUserAgent()});
                return null;
            }
        }
        return null;
    }

    public static HttpResponse txt(HttpRequest request, String bodyString) {
        return Resps.txt(request, bodyString, request.getHttpConfig().getCharset());
    }

    public static HttpResponse txt(HttpRequest request, String bodyString, String charset) {
        HttpResponse ret = Resps.string(request, bodyString, charset, MimeType.TEXT_PLAIN_TXT.getType() + ";charset=" + charset);
        return ret;
    }

    private Resps() {
    }
}

