/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache.caffeineredis;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.cache.CacheChangeType;
import org.tio.utils.cache.CacheChangedVo;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.cache.redis.RedisCache;
import org.tio.utils.cache.redis.RedisExpireUpdateTask;
import org.tio.utils.hutool.StrUtil;

public class CaffeineRedisCache
implements ICache {
    public static final String CACHE_CHANGE_TOPIC = "TIO_CACHE_CHANGE_TOPIC_CAFFEINE";
    private static Logger log = LoggerFactory.getLogger(CaffeineRedisCache.class);
    public static Map<String, CaffeineRedisCache> map = new HashMap<String, CaffeineRedisCache>();
    static RTopic<CacheChangedVo> topic;
    private static boolean inited;
    CaffeineCache caffeineCache;
    RedisCache redisCache;
    String cacheName;

    public static CaffeineRedisCache getCache(String cacheName) {
        CaffeineRedisCache caffeineRedisCache = map.get(cacheName);
        if (caffeineRedisCache == null) {
            log.warn("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)CaffeineRedisCache.class.getSimpleName());
        }
        return caffeineRedisCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init(RedissonClient redisson) {
        if (inited) return;
        Class<CaffeineRedisCache> clazz = CaffeineRedisCache.class;
        synchronized (CaffeineRedisCache.class) {
            if (inited) return;
            topic = redisson.getTopic(CACHE_CHANGE_TOPIC);
            topic.addListener((MessageListener)new MessageListener<CacheChangedVo>(){

                public void onMessage(String channel, CacheChangedVo cacheChangedVo) {
                    String clientid = cacheChangedVo.getClientId();
                    if (StrUtil.isBlank(clientid)) {
                        log.error("clientid is null");
                        return;
                    }
                    if (Objects.equals(CacheChangedVo.CLIENTID, clientid)) {
                        log.debug("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f,{}", (Object)clientid);
                        return;
                    }
                    String cacheName = cacheChangedVo.getCacheName();
                    CaffeineRedisCache caffeineRedisCache = CaffeineRedisCache.getCache(cacheName);
                    if (caffeineRedisCache == null) {
                        log.info("\u4e0d\u80fd\u6839\u636ecacheName[{}]\u627e\u5230CaffeineRedisCache\u5bf9\u8c61", (Object)cacheName);
                        return;
                    }
                    CacheChangeType type = cacheChangedVo.getType();
                    if (type == CacheChangeType.PUT || type == CacheChangeType.UPDATE || type == CacheChangeType.REMOVE) {
                        String key = cacheChangedVo.getKey();
                        caffeineRedisCache.caffeineCache.remove(key);
                    } else if (type == CacheChangeType.CLEAR) {
                        caffeineRedisCache.caffeineCache.clear();
                    }
                }
            });
            inited = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaffeineRedisCache register(RedissonClient redisson, String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        CaffeineRedisCache.init(redisson);
        CaffeineRedisCache caffeineRedisCache = map.get(cacheName);
        if (caffeineRedisCache != null) return caffeineRedisCache;
        Class<CaffeineRedisCache> clazz = CaffeineRedisCache.class;
        synchronized (CaffeineRedisCache.class) {
            caffeineRedisCache = map.get(cacheName);
            if (caffeineRedisCache != null) return caffeineRedisCache;
            RedisCache redisCache = RedisCache.register(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds);
            Long timeToLiveSecondsForCaffeine = timeToLiveSeconds;
            Long timeToIdleSecondsForCaffeine = timeToIdleSeconds;
            if (timeToLiveSecondsForCaffeine != null) {
                timeToLiveSecondsForCaffeine = Math.min(timeToLiveSecondsForCaffeine, 900L);
            }
            if (timeToIdleSecondsForCaffeine != null) {
                timeToIdleSecondsForCaffeine = Math.min(timeToIdleSecondsForCaffeine, 900L);
            }
            CaffeineCache caffeineCache = CaffeineCache.register(cacheName, timeToLiveSecondsForCaffeine, timeToIdleSecondsForCaffeine);
            caffeineRedisCache = new CaffeineRedisCache(cacheName, caffeineCache, redisCache);
            map.put(cacheName, caffeineRedisCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return caffeineRedisCache;
        }
    }

    public CaffeineRedisCache() {
    }

    public CaffeineRedisCache(String cacheName, CaffeineCache caffeineCache, RedisCache redisCache) {
        this.cacheName = cacheName;
        this.caffeineCache = caffeineCache;
        this.redisCache = redisCache;
    }

    @Override
    public void clear() {
        this.caffeineCache.clear();
        this.redisCache.clear();
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, CacheChangeType.CLEAR);
        topic.publish((Object)cacheChangedVo);
    }

    @Override
    public Serializable get(String key) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        Serializable ret = this.caffeineCache.get(key);
        if (ret == null) {
            ret = this.redisCache.get(key);
            if (ret != null) {
                this.caffeineCache.put(key, ret);
            }
        } else {
            Long timeToIdleSeconds = this.redisCache.getTimeToIdleSeconds();
            if (timeToIdleSeconds != null) {
                RedisExpireUpdateTask.add(this.cacheName, key, timeToIdleSeconds);
            }
        }
        return ret;
    }

    @Override
    public Iterable<String> keys() {
        return this.redisCache.keys();
    }

    @Override
    public void put(String key, Serializable value) {
        this.caffeineCache.put(key, value);
        this.redisCache.put(key, value);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.PUT);
        topic.publish((Object)cacheChangedVo);
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        this.caffeineCache.putTemporary(key, value);
        this.redisCache.putTemporary(key, value);
    }

    @Override
    public void remove(String key) {
        if (StrUtil.isBlank(key)) {
            return;
        }
        this.caffeineCache.remove(key);
        this.redisCache.remove(key);
        CacheChangedVo cacheChangedVo = new CacheChangedVo(this.cacheName, key, CacheChangeType.REMOVE);
        topic.publish((Object)cacheChangedVo);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key);
    }

    @Override
    public long ttl(String key) {
        return this.redisCache.ttl(key);
    }

    static {
        inited = false;
    }
}

