/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtil.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext.contains(String.valueOf('/')) || ext.contains(String.valueOf('\\')) ? "" : ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(byte[] data, File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        String canonicalPath = file.getCanonicalPath();
        OutputStream fos = null;
        try {
            fos = Files.newOutputStream(Paths.get(canonicalPath, new String[0]), new OpenOption[0]);
            fos.write(data);
            fos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            fos.close();
        }
    }

    public static void writeString(String content, String path, String charset) throws IOException {
        byte[] data = content.getBytes(charset);
        File file = new File(path);
        FileUtil.writeBytes(data, file);
    }
}

